/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;

class EcDhcBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhcBasicAgreement() {
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        if (!ecDomainParameters.equals(ecPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("ECCDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = ecDomainParameters.getH().multiply(this.key.getD()).mod(ecDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(ecDomainParameters.getCurve(), ecPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECCDH");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECCDH");
        }
        return eCPoint2.getAffineXCoord().toBigInteger();
    }
}

