/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.ArrayChannel;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ConflatedChannel;
import kotlinx.coroutines.channels.LinkedListChannel;
import kotlinx.coroutines.channels.RendezvousChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a>\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a8\u0006\n"}, d2={"Channel", "Lkotlinx/coroutines/channels/Channel;", "E", "capacity", "", "onBufferOverflow", "Lkotlinx/coroutines/channels/BufferOverflow;", "onUndeliveredElement", "Lkotlin/Function1;", "", "kotlinx-coroutines-core"})
public final class ChannelKt {
    @NotNull
    public static final <E> Channel<E> Channel(int capacity, @NotNull BufferOverflow onBufferOverflow, @Nullable Function1<? super E, Unit> onUndeliveredElement) {
        Channel channel;
        switch (capacity) {
            case 0: {
                channel = onBufferOverflow == BufferOverflow.SUSPEND ? (AbstractChannel)new RendezvousChannel<E>(onUndeliveredElement) : (AbstractChannel)new ArrayChannel<E>(1, onBufferOverflow, onUndeliveredElement);
                break;
            }
            case -1: {
                boolean bl = onBufferOverflow == BufferOverflow.SUSPEND;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "CONFLATED capacity cannot be used with non-default onBufferOverflow";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                channel = new ConflatedChannel<E>(onUndeliveredElement);
                break;
            }
            case 0x7FFFFFFF: {
                channel = new LinkedListChannel<E>(onUndeliveredElement);
                break;
            }
            case -2: {
                channel = new ArrayChannel<E>(onBufferOverflow == BufferOverflow.SUSPEND ? Channel.Factory.getCHANNEL_DEFAULT_CAPACITY$kotlinx_coroutines_core() : 1, onBufferOverflow, onUndeliveredElement);
                break;
            }
            default: {
                channel = capacity == 1 && onBufferOverflow == BufferOverflow.DROP_OLDEST ? (AbstractChannel)new ConflatedChannel<E>(onUndeliveredElement) : (AbstractChannel)new ArrayChannel<E>(capacity, onBufferOverflow, onUndeliveredElement);
            }
        }
        return channel;
    }

    public static /* synthetic */ Channel Channel$default(int n, BufferOverflow bufferOverflow, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bufferOverflow = BufferOverflow.SUSPEND;
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        return ChannelKt.Channel(n, bufferOverflow, function1);
    }

    public static /* synthetic */ Channel Channel$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ChannelKt.Channel$default(n, null, null, 6, null);
    }
}

