/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LockedSnapshotsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LockedSnapshotsInfo> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::ownerId)).setter(LockedSnapshotsInfo.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::snapshotId)).setter(LockedSnapshotsInfo.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockState").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::lockStateAsString)).setter(LockedSnapshotsInfo.setter(Builder::lockState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").unmarshallLocationName("lockState").build()}).build();
    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LockDuration").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::lockDuration)).setter(LockedSnapshotsInfo.setter(Builder::lockDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration").unmarshallLocationName("lockDuration").build()}).build();
    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoolOffPeriod").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::coolOffPeriod)).setter(LockedSnapshotsInfo.setter(Builder::coolOffPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod").unmarshallLocationName("coolOffPeriod").build()}).build();
    private static final SdkField<Instant> COOL_OFF_PERIOD_EXPIRES_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CoolOffPeriodExpiresOn").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::coolOffPeriodExpiresOn)).setter(LockedSnapshotsInfo.setter(Builder::coolOffPeriodExpiresOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriodExpiresOn").unmarshallLocationName("coolOffPeriodExpiresOn").build()}).build();
    private static final SdkField<Instant> LOCK_CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockCreatedOn").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::lockCreatedOn)).setter(LockedSnapshotsInfo.setter(Builder::lockCreatedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockCreatedOn").unmarshallLocationName("lockCreatedOn").build()}).build();
    private static final SdkField<Instant> LOCK_DURATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockDurationStartTime").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::lockDurationStartTime)).setter(LockedSnapshotsInfo.setter(Builder::lockDurationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDurationStartTime").unmarshallLocationName("lockDurationStartTime").build()}).build();
    private static final SdkField<Instant> LOCK_EXPIRES_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockExpiresOn").getter(LockedSnapshotsInfo.getter(LockedSnapshotsInfo::lockExpiresOn)).setter(LockedSnapshotsInfo.setter(Builder::lockExpiresOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockExpiresOn").unmarshallLocationName("lockExpiresOn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, SNAPSHOT_ID_FIELD, LOCK_STATE_FIELD, LOCK_DURATION_FIELD, COOL_OFF_PERIOD_FIELD, COOL_OFF_PERIOD_EXPIRES_ON_FIELD, LOCK_CREATED_ON_FIELD, LOCK_DURATION_START_TIME_FIELD, LOCK_EXPIRES_ON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LockedSnapshotsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String snapshotId;
    private final String lockState;
    private final Integer lockDuration;
    private final Integer coolOffPeriod;
    private final Instant coolOffPeriodExpiresOn;
    private final Instant lockCreatedOn;
    private final Instant lockDurationStartTime;
    private final Instant lockExpiresOn;

    private LockedSnapshotsInfo(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.snapshotId = builder.snapshotId;
        this.lockState = builder.lockState;
        this.lockDuration = builder.lockDuration;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.coolOffPeriodExpiresOn = builder.coolOffPeriodExpiresOn;
        this.lockCreatedOn = builder.lockCreatedOn;
        this.lockDurationStartTime = builder.lockDurationStartTime;
        this.lockExpiresOn = builder.lockExpiresOn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final LockState lockState() {
        return LockState.fromValue(this.lockState);
    }

    public final String lockStateAsString() {
        return this.lockState;
    }

    public final Integer lockDuration() {
        return this.lockDuration;
    }

    public final Integer coolOffPeriod() {
        return this.coolOffPeriod;
    }

    public final Instant coolOffPeriodExpiresOn() {
        return this.coolOffPeriodExpiresOn;
    }

    public final Instant lockCreatedOn() {
        return this.lockCreatedOn;
    }

    public final Instant lockDurationStartTime() {
        return this.lockDurationStartTime;
    }

    public final Instant lockExpiresOn() {
        return this.lockExpiresOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolOffPeriodExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockCreatedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDurationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockExpiresOn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockedSnapshotsInfo)) {
            return false;
        }
        LockedSnapshotsInfo other = (LockedSnapshotsInfo)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.lockStateAsString(), other.lockStateAsString()) && Objects.equals(this.lockDuration(), other.lockDuration()) && Objects.equals(this.coolOffPeriod(), other.coolOffPeriod()) && Objects.equals(this.coolOffPeriodExpiresOn(), other.coolOffPeriodExpiresOn()) && Objects.equals(this.lockCreatedOn(), other.lockCreatedOn()) && Objects.equals(this.lockDurationStartTime(), other.lockDurationStartTime()) && Objects.equals(this.lockExpiresOn(), other.lockExpiresOn());
    }

    public final String toString() {
        return ToString.builder((String)"LockedSnapshotsInfo").add("OwnerId", (Object)this.ownerId()).add("SnapshotId", (Object)this.snapshotId()).add("LockState", (Object)this.lockStateAsString()).add("LockDuration", (Object)this.lockDuration()).add("CoolOffPeriod", (Object)this.coolOffPeriod()).add("CoolOffPeriodExpiresOn", (Object)this.coolOffPeriodExpiresOn()).add("LockCreatedOn", (Object)this.lockCreatedOn()).add("LockDurationStartTime", (Object)this.lockDurationStartTime()).add("LockExpiresOn", (Object)this.lockExpiresOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "LockState": {
                return Optional.ofNullable(clazz.cast(this.lockStateAsString()));
            }
            case "LockDuration": {
                return Optional.ofNullable(clazz.cast(this.lockDuration()));
            }
            case "CoolOffPeriod": {
                return Optional.ofNullable(clazz.cast(this.coolOffPeriod()));
            }
            case "CoolOffPeriodExpiresOn": {
                return Optional.ofNullable(clazz.cast(this.coolOffPeriodExpiresOn()));
            }
            case "LockCreatedOn": {
                return Optional.ofNullable(clazz.cast(this.lockCreatedOn()));
            }
            case "LockDurationStartTime": {
                return Optional.ofNullable(clazz.cast(this.lockDurationStartTime()));
            }
            case "LockExpiresOn": {
                return Optional.ofNullable(clazz.cast(this.lockExpiresOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("LockState", LOCK_STATE_FIELD);
        map.put("LockDuration", LOCK_DURATION_FIELD);
        map.put("CoolOffPeriod", COOL_OFF_PERIOD_FIELD);
        map.put("CoolOffPeriodExpiresOn", COOL_OFF_PERIOD_EXPIRES_ON_FIELD);
        map.put("LockCreatedOn", LOCK_CREATED_ON_FIELD);
        map.put("LockDurationStartTime", LOCK_DURATION_START_TIME_FIELD);
        map.put("LockExpiresOn", LOCK_EXPIRES_ON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LockedSnapshotsInfo, T> g) {
        return obj -> g.apply((LockedSnapshotsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String snapshotId;
        private String lockState;
        private Integer lockDuration;
        private Integer coolOffPeriod;
        private Instant coolOffPeriodExpiresOn;
        private Instant lockCreatedOn;
        private Instant lockDurationStartTime;
        private Instant lockExpiresOn;

        private BuilderImpl() {
        }

        private BuilderImpl(LockedSnapshotsInfo model) {
            this.ownerId(model.ownerId);
            this.snapshotId(model.snapshotId);
            this.lockState(model.lockState);
            this.lockDuration(model.lockDuration);
            this.coolOffPeriod(model.coolOffPeriod);
            this.coolOffPeriodExpiresOn(model.coolOffPeriodExpiresOn);
            this.lockCreatedOn(model.lockCreatedOn);
            this.lockDurationStartTime(model.lockDurationStartTime);
            this.lockExpiresOn(model.lockExpiresOn);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getLockState() {
            return this.lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final Integer getLockDuration() {
            return this.lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return this.coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Instant getCoolOffPeriodExpiresOn() {
            return this.coolOffPeriodExpiresOn;
        }

        public final void setCoolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
        }

        @Override
        public final Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
            return this;
        }

        public final Instant getLockCreatedOn() {
            return this.lockCreatedOn;
        }

        public final void setLockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
        }

        @Override
        public final Builder lockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
            return this;
        }

        public final Instant getLockDurationStartTime() {
            return this.lockDurationStartTime;
        }

        public final void setLockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
        }

        @Override
        public final Builder lockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
            return this;
        }

        public final Instant getLockExpiresOn() {
            return this.lockExpiresOn;
        }

        public final void setLockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
        }

        @Override
        public final Builder lockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
            return this;
        }

        public LockedSnapshotsInfo build() {
            return new LockedSnapshotsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LockedSnapshotsInfo> {
        public Builder ownerId(String var1);

        public Builder snapshotId(String var1);

        public Builder lockState(String var1);

        public Builder lockState(LockState var1);

        public Builder lockDuration(Integer var1);

        public Builder coolOffPeriod(Integer var1);

        public Builder coolOffPeriodExpiresOn(Instant var1);

        public Builder lockCreatedOn(Instant var1);

        public Builder lockDurationStartTime(Instant var1);

        public Builder lockExpiresOn(Instant var1);
    }
}

