/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.Locale;
import org.opensearch.core.common.Strings;

public enum RegexpFlag {
    INTERSECTION(1),
    COMPLEMENT(65536),
    EMPTY(4),
    ANYSTRING(8),
    INTERVAL(32),
    NONE(0),
    ALL(255);

    final int value;

    private RegexpFlag(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static int resolveValue(String flags) {
        if (flags == null || flags.isEmpty()) {
            return 255;
        }
        int magic = 0;
        for (String s : Strings.delimitedListToStringArray((String)flags, (String)"|")) {
            if (s.isEmpty()) continue;
            try {
                RegexpFlag flag = RegexpFlag.valueOf(s.toUpperCase(Locale.ROOT));
                if (flag == NONE) continue;
                if (flag == ALL) {
                    return flag.value();
                }
                magic |= flag.value();
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown regexp flag [" + s + "]");
            }
        }
        return magic;
    }
}

