/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.hash.T1ha1;
import org.opensearch.index.codec.fuzzy.FuzzySet;

public abstract class AbstractFuzzySet
implements FuzzySet {
    protected abstract void add(BytesRef var1);

    protected void addAll(CheckedSupplier<Iterator<BytesRef>, IOException> valuesIteratorProvider) throws IOException {
        Iterator values = (Iterator)valuesIteratorProvider.get();
        while (values.hasNext()) {
            this.add((BytesRef)values.next());
        }
    }

    @Override
    public FuzzySet.Result contains(BytesRef val) {
        return this.containsHash(this.generateKey(val));
    }

    protected abstract FuzzySet.Result containsHash(long var1);

    protected long generateKey(BytesRef value) {
        return T1ha1.hash((byte[])value.bytes, (int)value.offset, (int)value.length, (long)0L);
    }

    protected void assertAllElementsExist(CheckedSupplier<Iterator<BytesRef>, IOException> iteratorProvider) throws IOException {
        Iterator iter = (Iterator)iteratorProvider.get();
        int cnt = 0;
        while (iter.hasNext()) {
            BytesRef item = (BytesRef)iter.next();
            assert (this.contains(item) == FuzzySet.Result.MAYBE) : "Expected Filter to return positive response for elements added to it. Elements matched: " + cnt;
            ++cnt;
        }
    }
}

