/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.FilterChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilterGraph {
    private final List<FilterChain> chains = new ArrayList<FilterChain>();

    public FilterGraph addFilterChain(FilterChain chain) {
        this.chains.add(chain);
        return this;
    }

    public FilterGraph addFilterChains(List<? extends FilterChain> chainsToAdd) {
        this.chains.addAll(chainsToAdd);
        return this;
    }

    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (FilterChain chain : this.chains) {
            if (!first) {
                result.append(";");
            }
            result.append(chain.getValue());
            first = false;
        }
        return result.toString();
    }

    public static FilterGraph of(FilterChain ... filterChains) {
        return new FilterGraph().addFilterChains(Arrays.asList(filterChains));
    }
}

