/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import java.lang.constant.ClassDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.util.List;
import java.util.function.BiFunction;

final class InvokeDynamic
extends Item {
    private final List<? extends Expr> args;
    private final DynamicCallSiteDesc callSiteDesc;

    InvokeDynamic(List<? extends Expr> args, DynamicCallSiteDesc callSiteDesc) {
        this.args = args;
        this.callSiteDesc = callSiteDesc;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        node = node.prev();
        for (int i = this.args.size() - 1; i >= 0; --i) {
            Item arg = (Item)this.args.get(i);
            node = arg.process(node, op);
        }
        return node;
    }

    @Override
    public ClassDesc type() {
        return this.callSiteDesc.invocationType().returnType();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invokedynamic(this.callSiteDesc);
    }
}

