#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-ClkpLNlN0bK2T7l0sPzpZM
key:                  tree-diff-0.3.0.1-ClkpLNlN0bK2T7l0sPzpZM
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  816a9e6263c1d8585760834b17d36438
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-ClkpLNlN0bK2T7l0sPzpZM
depends:
    QuickCheck-2.15.0.1-HjS4TEwsqmECLyEigdP31V
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    ansi-terminal-1.0.2-EPVLF4zwBLpAhuvD3wgQPr
    ansi-wl-pprint-1.0.2-FzejDYZBNSuHr6uBKfTTdG base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko parsec-3.1.16.1
    parsers-0.12.12-ZAuPTjvTfk5DldhmoxnGL pretty-1.1.3.6
    primitive-0.9.1.0-CAiXP181yOJM9BA05PVbs
    scientific-0.3.8.0-9gOL1qaAy2CzOZP0iULD0
    semialign-1.3.1-1kpA8zWmZldGA9rh2lCSsh
    strict-0.5.1-IXHiBjvxCx3BeaJ1wAutq0
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-Kq68TsqD55a4HPmlw9AcBI time-1.12.2
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    uuid-types-1.0.6-6DQnO22Hc9Dr7cY3WKMEY
    vector-0.13.2.0-JUxTFkVHiOCDvdzFqkdqvm

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

