/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildconfiguration.tasks;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.internal.buildconfiguration.tasks.DaemonJvmPropertiesModifier;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.platform.BuildPlatform;
import org.gradle.util.internal.IncubationLogger;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
@Incubating
public abstract class UpdateDaemonJvm
extends DefaultTask {
    public static final ProblemId TASK_CONFIGURATION_PROBLEM_ID = ProblemId.create((String)"task-configuration", (String)"Invalid task configuration", (ProblemGroup)GradleCoreProblemGroup.daemonToolchain().configurationGeneration());
    private final DaemonJvmPropertiesModifier daemonJvmPropertiesModifier;

    @Inject
    public UpdateDaemonJvm(DaemonJvmPropertiesModifier daemonJvmPropertiesModifier) {
        this.daemonJvmPropertiesModifier = daemonJvmPropertiesModifier;
    }

    @TaskAction
    void generate() {
        IncubationLogger.incubatingFeatureUsed((String)"Daemon JVM criteria");
        String jvmVendorCriteria = this.getVendor().isPresent() ? (String)this.getVendor().map(v -> ((DefaultJvmVendorSpec)v).toCriteria()).get() : null;
        this.daemonJvmPropertiesModifier.updateJvmCriteria(((RegularFile)this.getPropertiesFile().get()).getAsFile(), (JavaLanguageVersion)this.getLanguageVersion().get(), jvmVendorCriteria, (Boolean)this.getNativeImageCapable().getOrElse((Object)false), (Map)this.getToolchainDownloadUrls().get());
    }

    @OutputFile
    @Incubating
    public abstract RegularFileProperty getPropertiesFile();

    @Input
    @Optional
    @Option(option="jvm-version", description="The version of the JVM required to run the Gradle Daemon.")
    @Incubating
    public abstract Property<JavaLanguageVersion> getLanguageVersion();

    @Input
    @Optional
    @Incubating
    @Option(option="jvm-vendor", description="The vendor of the JVM required to run the Gradle Daemon.")
    public abstract Property<JvmVendorSpec> getVendor();

    @OptionValues(value={"jvm-vendor"})
    public List<String> getAvailableVendors() {
        return Arrays.stream(JvmVendor.KnownJvmVendor.values()).filter(e -> e != JvmVendor.KnownJvmVendor.UNKNOWN).map(Enum::name).collect(Collectors.toList());
    }

    @Input
    @Optional
    @Incubating
    @Option(option="native-image-capable", description="Indicates if the native-image capability is required.")
    public abstract Property<Boolean> getNativeImageCapable();

    @Internal
    @Incubating
    public abstract SetProperty<BuildPlatform> getToolchainPlatforms();

    @Input
    @Incubating
    public abstract MapProperty<BuildPlatform, URI> getToolchainDownloadUrls();
}

