/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.NumberUtils;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.NearbyPointsMethod;

public class NearbyFactorMethod
extends NearbyPointsMethod {
    private final int _factor;

    public NearbyFactorMethod(int n) {
        this._factor = n;
    }

    public NearbyFactorMethod(String string) {
        this._factor = NumberUtils.getIntOrZero(NearbyFactorMethod.recogniseString(string) ? string.substring(4) : string);
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.NEARBY_WITH_FACTOR;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._factor);
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._factor;
    }

    static boolean recogniseString(String string) {
        return NearbyFactorMethod.recogniseString(string, CompressionMethodType.NEARBY_WITH_FACTOR);
    }

    @Override
    protected double getRadianThreshold(TrackDetails trackDetails) {
        double d;
        double d2 = d = this._factor <= 0 ? 1.0 : 1.0 / (double)this._factor;
        if (d <= 0.0 || d >= 1.0) {
            return 0.0;
        }
        return trackDetails.getMaxRadians() * d;
    }
}

