/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.List;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;

public abstract class UnitSetLibrary {
    public static final Unit UNITS_FEET = new Unit("feet", 3.2808);
    public static final Unit UNITS_METRES = new Unit("metres");
    public static final Unit UNITS_KILOMETRES = new Unit("kilometres", 0.001);
    public static final Unit UNITS_MILES = new Unit("miles", 6.213881811967936E-4);
    public static final Unit UNITS_NAUTICAL_MILES = new Unit("nauticalmiles", 5.399568034557236E-4);
    public static final Unit SPEED_UNITS_METRESPERSEC = new Unit(UNITS_METRES, "persec");
    public static final Unit SPEED_UNITS_FEETPERSEC = new Unit(UNITS_FEET, "persec");
    public static final Unit SPEED_UNITS_MILESPERHOUR = new Unit(UNITS_MILES, "perhour", 3600.0);
    public static final Unit SPEED_UNITS_KNOTS = new Unit(UNITS_NAUTICAL_MILES, "perhour", 3600.0);
    public static final Unit SPEED_UNITS_KMPERHOUR = new Unit(UNITS_KILOMETRES, "perhour", 3600.0);
    public static final List<Unit> ALL_SPEED_UNITS = List.of(SPEED_UNITS_METRESPERSEC, SPEED_UNITS_KMPERHOUR, SPEED_UNITS_FEETPERSEC, SPEED_UNITS_MILESPERHOUR);
    private static final UnitSet[] _sets = new UnitSet[]{new UnitSet("unitset.kilometres", UNITS_KILOMETRES, UNITS_METRES, SPEED_UNITS_KMPERHOUR, SPEED_UNITS_METRESPERSEC), new UnitSet("unitset.miles", UNITS_MILES, UNITS_FEET, SPEED_UNITS_MILESPERHOUR, SPEED_UNITS_FEETPERSEC), new UnitSet("unitset.nautical", UNITS_NAUTICAL_MILES, UNITS_FEET, SPEED_UNITS_KNOTS, SPEED_UNITS_FEETPERSEC)};
    private static final int UNITSET_METRIC = 0;

    public static int getNumUnitSets() {
        return _sets.length;
    }

    public static UnitSet getUnitSet(int n) {
        if (n >= 0 && n < UnitSetLibrary.getNumUnitSets()) {
            return _sets[n];
        }
        return _sets[0];
    }

    public static UnitSet getUnitSet(String string) {
        UnitSet[] unitSetArray = _sets;
        int n = _sets.length;
        int n2 = 0;
        while (n2 < n) {
            UnitSet unitSet = unitSetArray[n2];
            if (unitSet.getNameKey().equals(string)) {
                return unitSet;
            }
            ++n2;
        }
        return UnitSetLibrary.getUnitSet(0);
    }

    public static UnitSet getMetricUnitSet() {
        return UnitSetLibrary.getUnitSet(0);
    }
}

