#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-7a1RO7KVduHK8vRoCj8BYm
key:                  dhall-1.42.3-7a1RO7KVduHK8vRoCj8BYm
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  e9af41fa8151a5356becb4e3529aa3e2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-7a1RO7KVduHK8vRoCj8BYm
depends:
    Diff-0.5-Iz6Klc6Zm5z1jTIw09K3iw aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    aeson-pretty-0.8.10-3EriKxX8fC4C6Y9DlTYVfw
    ansi-terminal-1.0.2-EPVLF4zwBLpAhuvD3wgQPr
    atomic-write-0.2.1.1-FGYrvalRuSc77qZtFXzTN4 base-4.17.2.1
    base16-bytestring-1.0.2.0-JZm1Tyl0W6M67ZsN0BpZnT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-42k9iOSknrb4MqDPwxdyM4
    cborg-0.2.10.0-LdvEHsIqij138axIZj1mhJ
    cborg-json-0.2.6.0-BkbVQcftsmvLGjkfqUkUT4 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-JQTOrIzL3Bd4gfLtnHBXGX
    data-fix-0.3.4-CA113wro7TE4nK7icVvQv deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-GbPNlhnvfo4KNBijysVCJo exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-6AaalRDQtYRDwJreH7LVyn
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko haskeline-0.8.2
    http-client-0.7.19-CGIiAJO6qfCADepj1ASGVk
    http-client-tls-0.3.6.4-Fi8IRjkKHwaC5vXzfxQwF1
    http-types-0.12.4-7VKWb71irDD4uKtGM0MrBb
    indexed-traversable-0.1.4-FfUdEnAMiICEjkktWzJVYw
    megaparsec-9.7.0-1JRkSOE0CLKI56z4E4coO3
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
    optparse-applicative-0.18.1.0-I864cMO0U1ABRAZwcl7eB7
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-ZAuPTjvTfk5DldhmoxnGL
    pretty-simple-4.1.3.0-FjwNrCV4TqE43vmO2ngMla
    prettyprinter-1.7.1-158pI0o122BKJZoFMaU38n
    prettyprinter-ansi-terminal-1.1.3-Jg2E3zNlKEwGwLqAGW8Hky
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-9gOL1qaAy2CzOZP0iULD0
    serialise-0.2.6.1-lDifxD1in6As9Js5GmxnT template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-B7cu2G4i7FmERFIbq6VT1K
    text-short-0.1.6-6vOVOaP6CV69AwW6JtiK6C
    th-lift-instances-0.1.20-BZNecExsDyd4oABspqf33r time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-CmOIYoDybN9DOhK0mZM0Em
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    vector-0.13.2.0-JUxTFkVHiOCDvdzFqkdqvm

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

