/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.prompt;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISqlJoinRule;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AIPromptGenerateSql
extends AIPromptAbstract {
    public static final String SQL_GENERATOR_ID = "sql";
    public static final String[] SQL_GENERATE_GOALS = new String[]{"Help users write SQL queries.", "Provide information about SQL syntax, functions, and best practices.", "Assist with database design and data modeling.", "Answer questions about database concepts and technologies.", "Provide information about database performance tuning and optimization."};
    public static final String[] SQL_OUTPUT_FORMATS = new String[]{"Place any explanation or comments before the SQL code block.", "Provide the SQL query in a fenced Markdown code block."};

    @Override
    @NotNull
    public String generatorId() {
        return SQL_GENERATOR_ID;
    }

    @NotNull
    public static AIPromptGenerateSql create(@NotNull DBSLogicalDataSourceSupplier dsSupplier) {
        AIPromptGenerateSql builder = new AIPromptGenerateSql();
        AIPromptGenerateSql.addSqlGenerateInstructions(dsSupplier, builder);
        return builder;
    }

    public static void addSqlGenerateInstructions(@NotNull DBSLogicalDataSourceSupplier dsSupplier, @NotNull AIPromptAbstract builder) {
        DBSLogicalDataSource dataSource = (DBSLogicalDataSource)dsSupplier.get();
        if (dataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo(dataSource)).addInstructions(AIPromptUtils.createGenerateQueryInstructions(dataSource));
        }
        builder.addGoals(SQL_GENERATE_GOALS).addOutputFormats(SQL_OUTPUT_FORMATS);
        AIPromptGenerateSql.addJoinInstructions(builder);
    }

    public static void addJoinInstructions(AIPromptAbstract builder) {
        AISqlJoinRule joinRule = (AISqlJoinRule)CommonUtils.valueOf(AISqlJoinRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.joinRule"), (Enum)AISqlJoinRule.DEFAULT);
        String joinHint = switch (joinRule) {
            case AISqlJoinRule.JOIN -> "Use joins only.";
            case AISqlJoinRule.SUB_QUERY -> "Use sub\u2011queries only.";
            default -> "Joins and sub\u2011queries are allowed.";
        };
        builder.addInstructions(joinHint);
    }
}

