/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.ide.ResourceSelectionUtil;

public class RefactorActionGroup
extends ActionGroup {
    private RenameResourceAction renameAction;
    private MoveResourceAction moveAction;
    private final Shell shell;
    private final Tree tree;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(Shell aShell, Tree aTree) {
        this.shell = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        if (anyResourceSelected) {
            this.moveAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.textActionHandler != null) {
            this.textActionHandler.dispose();
        }
        this.textActionHandler = new TextActionHandler(actionBars, true);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        IShellProvider sp = () -> this.shell;
        this.moveAction = new MoveResourceAction(sp);
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new RenameResourceAction(sp, this.tree);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }

    public void dispose() {
        if (this.textActionHandler != null) {
            this.textActionHandler.dispose();
        }
        this.textActionHandler = null;
        super.dispose();
    }
}

