/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridPrivilage
implements DBSObject {
    private String name;
    private String description;
    private boolean persisted = false;
    private CubridDataSource container;
    private List<String> groups = new ArrayList<String>();

    public CubridPrivilage(@NotNull CubridDataSource container, @NotNull String name, @Nullable JDBCResultSet dbResult) {
        this.container = container;
        this.name = name;
        if (dbResult != null) {
            this.persisted = true;
            this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
            String sql = "select t.groups.name from db_user join table(groups) as t(groups) where name = ?";
            sql = container.wrapShardQuery(sql);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (JDBCPreparedStatement dbStat = dbResult.getSession().prepareStatement(sql);){
                    dbStat.setString(1, name);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCResultSet result = dbStat.executeQuery();){
                        while (result.next()) {
                            this.groups.add(JDBCUtils.safeGetString((ResultSet)result, (String)"groups.name"));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                new DBException("Load group name failed", (Throwable)e);
            }
        }
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Nullable
    public List<String> getRoles() {
        return this.groups;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getGroups() {
        return String.join((CharSequence)", ", this.groups);
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CubridDataSource getParentObject() {
        return this.getDataSource();
    }

    public CubridDataSource getDataSource() {
        return this.container;
    }
}

