﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/ResourceIdentifier.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {
class DescribeAuditSuppressionResult {
 public:
  AWS_IOT_API DescribeAuditSuppressionResult() = default;
  AWS_IOT_API DescribeAuditSuppressionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOT_API DescribeAuditSuppressionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetCheckName() const { return m_checkName; }
  template <typename CheckNameT = Aws::String>
  void SetCheckName(CheckNameT&& value) {
    m_checkNameHasBeenSet = true;
    m_checkName = std::forward<CheckNameT>(value);
  }
  template <typename CheckNameT = Aws::String>
  DescribeAuditSuppressionResult& WithCheckName(CheckNameT&& value) {
    SetCheckName(std::forward<CheckNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResourceIdentifier& GetResourceIdentifier() const { return m_resourceIdentifier; }
  template <typename ResourceIdentifierT = ResourceIdentifier>
  void SetResourceIdentifier(ResourceIdentifierT&& value) {
    m_resourceIdentifierHasBeenSet = true;
    m_resourceIdentifier = std::forward<ResourceIdentifierT>(value);
  }
  template <typename ResourceIdentifierT = ResourceIdentifier>
  DescribeAuditSuppressionResult& WithResourceIdentifier(ResourceIdentifierT&& value) {
    SetResourceIdentifier(std::forward<ResourceIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The epoch timestamp in seconds at which this suppression expires. </p>
   */
  inline const Aws::Utils::DateTime& GetExpirationDate() const { return m_expirationDate; }
  template <typename ExpirationDateT = Aws::Utils::DateTime>
  void SetExpirationDate(ExpirationDateT&& value) {
    m_expirationDateHasBeenSet = true;
    m_expirationDate = std::forward<ExpirationDateT>(value);
  }
  template <typename ExpirationDateT = Aws::Utils::DateTime>
  DescribeAuditSuppressionResult& WithExpirationDate(ExpirationDateT&& value) {
    SetExpirationDate(std::forward<ExpirationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Indicates whether a suppression should exist indefinitely or not. </p>
   */
  inline bool GetSuppressIndefinitely() const { return m_suppressIndefinitely; }
  inline void SetSuppressIndefinitely(bool value) {
    m_suppressIndefinitelyHasBeenSet = true;
    m_suppressIndefinitely = value;
  }
  inline DescribeAuditSuppressionResult& WithSuppressIndefinitely(bool value) {
    SetSuppressIndefinitely(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The description of the audit suppression. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeAuditSuppressionResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeAuditSuppressionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_checkName;
  bool m_checkNameHasBeenSet = false;

  ResourceIdentifier m_resourceIdentifier;
  bool m_resourceIdentifierHasBeenSet = false;

  Aws::Utils::DateTime m_expirationDate{};
  bool m_expirationDateHasBeenSet = false;

  bool m_suppressIndefinitely{false};
  bool m_suppressIndefinitelyHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
