"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const e = exposes.presets;
const ea = exposes.access;
exports.definitions = [
    {
        zigbeeModel: ["TERNCY-WS01-S4"],
        model: "TERNCY-WS01",
        vendor: "TERNCY",
        description: "Smart light switch - 4 gang without neutral wire",
        extend: [m.deviceEndpoints({ endpoints: { l1: 1, l2: 2, l3: 3, l4: 4 } }), m.onOff({ endpointNames: ["l1", "l2", "l3", "l4"] })],
    },
    {
        zigbeeModel: ["DL001"],
        model: "DL001",
        vendor: "TERNCY",
        description: "Two color temperature intelligent downlight",
        extend: [m.light({ colorTemp: { range: [156, 476] } })],
    },
    {
        zigbeeModel: ["TERNCY-DC01"],
        model: "TERNCY-DC01",
        vendor: "TERNCY",
        description: "Temperature & contact sensor ",
        fromZigbee: [fz.terncy_temperature, fz.terncy_contact, fz.battery],
        toZigbee: [],
        exposes: [e.temperature(), e.contact(), e.battery()],
        meta: { battery: { dontDividePercentage: true } },
    },
    {
        zigbeeModel: ["TERNCY-PP01"],
        model: "TERNCY-PP01",
        vendor: "TERNCY",
        description: "Awareness switch",
        fromZigbee: [fz.terncy_temperature, fz.occupancy_with_timeout, fz.terncy_raw, fz.battery],
        exposes: [e.temperature(), e.occupancy(), e.action(["single", "double", "triple", "quadruple"])],
        toZigbee: [],
        meta: { battery: { dontDividePercentage: true } },
        extend: [m.illuminance()],
    },
    {
        zigbeeModel: ["TERNCY-SD01"],
        model: "TERNCY-SD01",
        vendor: "TERNCY",
        description: "Knob smart dimmer",
        fromZigbee: [fz.terncy_raw, fz.terncy_knob, fz.battery],
        toZigbee: [],
        ota: true,
        meta: { battery: { dontDividePercentage: true } },
        exposes: [e.battery(), e.action(["single", "double", "triple", "quadruple", "rotate"]), e.text("direction", ea.STATE)],
    },
    {
        zigbeeModel: ["TERNCY-LS01"],
        model: "TERNCY-LS01",
        vendor: "TERNCY",
        description: "Smart light socket",
        exposes: [e.switch(), e.action(["single"])],
        fromZigbee: [fz.on_off, fz.terncy_raw, fz.ignore_basic_report],
        toZigbee: [tz.on_off],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genOnOff"]);
        },
    },
    {
        zigbeeModel: ["CL001"],
        model: "CL001",
        vendor: "TERNCY",
        description: "Beevon ceiling light",
        ota: true,
        extend: [m.light({ colorTemp: { range: [50, 500] }, powerOnBehavior: false, effect: false })],
    },
];
//# sourceMappingURL=terncy.js.map