/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterListType;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyTypeRenderer
extends PyTypeVisitorExt<HtmlChunk> {
    private static final int MAX_DEPTH = 6;
    protected int myDepth;
    @NotNull
    protected final TypeEvalContext myTypeEvalContext;

    private PyTypeRenderer(@NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyTypeRenderer.$$$reportNull$$$0(0);
        }
        this.myDepth = 0;
        this.myTypeEvalContext = typeEvalContext;
    }

    protected boolean maxDepthExceeded() {
        return this.myDepth > 6;
    }

    @NotNull
    protected HtmlChunk render(@Nullable PyType type2) {
        if (this.maxDepthExceeded()) {
            HtmlChunk htmlChunk = this.styled("...", PyHighlighter.PY_DOT);
            if (htmlChunk == null) {
                PyTypeRenderer.$$$reportNull$$$0(1);
            }
            return htmlChunk;
        }
        ++this.myDepth;
        HtmlChunk htmlChunk = PyTypeRenderer.visit(type2, this);
        HtmlChunk htmlChunk2 = htmlChunk;
        if (htmlChunk2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(2);
        }
        return htmlChunk2;
        finally {
            --this.myDepth;
        }
    }

    @NotNull
    protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
        if (style == null) {
            PyTypeRenderer.$$$reportNull$$$0(3);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)StringUtil.notNullize((String)text));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(4);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk escaped(@Nls String text) {
        HtmlChunk htmlChunk = HtmlChunk.raw((String)StringUtil.notNullize((String)text));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(5);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk className(@Nls String name2) {
        HtmlChunk htmlChunk = this.escaped(name2);
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk styledExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            PyTypeRenderer.$$$reportNull$$$0(7);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)expression.getText());
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(8);
        }
        return htmlChunk;
    }

    protected final boolean isBitwiseOrUnionAvailable() {
        return PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myTypeEvalContext);
    }

    protected final boolean isGenericBuiltinsAvailable() {
        PsiFile origin = this.myTypeEvalContext.getOrigin();
        return origin == null || PythonLanguageLevelPusher.getLanguageLevelForFile(origin).isAtLeast(LanguageLevel.PYTHON39);
    }

    @Override
    public HtmlChunk visitPyGenericType(@NotNull PyCollectionType collectionOf) {
        if (collectionOf == null) {
            PyTypeRenderer.$$$reportNull$$$0(9);
        }
        HtmlChunk genericTypeRender = this.renderGenericType(collectionOf);
        return collectionOf.isDefinition() ? this.wrapInTypingType(genericTypeRender) : genericTypeRender;
    }

    @NotNull
    private HtmlChunk renderGenericType(@NotNull PyCollectionType genericType) {
        if (genericType == null) {
            PyTypeRenderer.$$$reportNull$$$0(10);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        boolean renderTypeArgumentList = !genericType.getElementTypes().isEmpty();
        String className = genericType.getPyClass().getName();
        if (renderTypeArgumentList && !this.isGenericBuiltinsAvailable() && PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.containsKey((Object)className)) {
            result2.append(this.className((String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.get((Object)className)));
        } else {
            result2.append(this.className(className));
        }
        if (renderTypeArgumentList) {
            result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result2.append(this.renderList(ContainerUtil.map(genericType.getElementTypes(), this::render)));
            result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(11);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk wrapInTypingType(@NotNull HtmlChunk instanceTypeRender) {
        if (instanceTypeRender == null) {
            PyTypeRenderer.$$$reportNull$$$0(12);
        }
        HtmlChunk htmlChunk = new HtmlBuilder().append(this.isGenericBuiltinsAvailable() ? this.styled("type", PyHighlighter.PY_BUILTIN_NAME) : this.escaped("Type")).append(this.styled("[", PyHighlighter.PY_BRACKETS)).append(instanceTypeRender).append(this.styled("]", PyHighlighter.PY_BRACKETS)).toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(13);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    public HtmlChunk visitPyClassLikeType(@NotNull PyClassLikeType classLikeType) {
        if (classLikeType == null) {
            PyTypeRenderer.$$$reportNull$$$0(14);
        }
        HtmlChunk classTypeRender = this.className(classLikeType.getName());
        HtmlChunk htmlChunk = classLikeType.isDefinition() ? this.wrapInTypingType(classTypeRender) : classTypeRender;
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(15);
        }
        return htmlChunk;
    }

    @Override
    public HtmlChunk visitPyNarrowedType(@NotNull PyNarrowedType narrowedType) {
        if (narrowedType == null) {
            PyTypeRenderer.$$$reportNull$$$0(16);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        if (narrowedType.getTypeIs()) {
            result2.append(this.styled("TypeIs", PyHighlighter.PY_CLASS_DEFINITION));
        } else {
            result2.append(this.styled("TypeGuard", PyHighlighter.PY_CLASS_DEFINITION));
        }
        result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
        result2.append(this.render(narrowedType.getNarrowedType()));
        result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        return result2.toFragment();
    }

    @Override
    @NotNull
    public HtmlChunk visitPyNeverType(@NotNull PyNeverType neverType) {
        if (neverType == null) {
            PyTypeRenderer.$$$reportNull$$$0(17);
        }
        HtmlChunk htmlChunk = this.className(neverType.getName());
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(18);
        }
        return htmlChunk;
    }

    @Override
    public HtmlChunk visitPyUnionType(@NotNull PyUnionType unionType) {
        if (unionType == null) {
            PyTypeRenderer.$$$reportNull$$$0(19);
        }
        if (PyTypeRenderer.isOptional(unionType)) {
            return this.renderOptional(unionType);
        }
        Pair<List<PyLiteralType>, List<PyType>> literalsAndOthers = PyTypeRenderer.extractLiterals(unionType);
        if (literalsAndOthers != null) {
            if (((List)literalsAndOthers.second).isEmpty()) {
                return this.renderUnionOfLiterals((List)literalsAndOthers.first);
            }
            return this.renderUnion(ContainerUtil.prepend((List)ContainerUtil.map((Collection)((Collection)literalsAndOthers.second), this::render), (Object[])new HtmlChunk[]{this.renderUnionOfLiterals((List)literalsAndOthers.first)}));
        }
        if (ContainerUtil.all(unionType.getMembers(), t -> {
            PyClassType ct;
            return t instanceof PyClassType && (ct = (PyClassType)t).isDefinition();
        })) {
            return this.wrapInTypingType(this.render(unionType.map(type2 -> type2 != null ? (PyType)((PyClassType)type2).toInstance() : null)));
        }
        if (PyTypeChecker.isUnknown(unionType, false, this.myTypeEvalContext)) {
            return this.renderUnion(List.of(this.render(unionType.excludeNull()), this.visitUnknownType()));
        }
        return this.renderUnion(ContainerUtil.map(unionType.getMembers(), this::render));
    }

    @NotNull
    private HtmlChunk renderUnionOfLiterals(@NotNull List<PyLiteralType> literals) {
        if (literals == null) {
            PyTypeRenderer.$$$reportNull$$$0(20);
        }
        HtmlChunk htmlChunk = new HtmlBuilder().append(this.escaped("Literal")).append(this.styled("[", PyHighlighter.PY_BRACKETS)).append((HtmlChunk)StreamEx.of(literals).map(PyLiteralType::getExpression).map(expr -> this.styledExpression((PyExpression)expr)).collect(HtmlChunk.toFragment((HtmlChunk)this.styled(", ", PyHighlighter.PY_COMMA)))).append(this.styled("]", PyHighlighter.PY_BRACKETS)).toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(21);
        }
        return htmlChunk;
    }

    @NotNull
    private HtmlChunk renderUnion(@NotNull List<HtmlChunk> renderedUnionMembers) {
        if (renderedUnionMembers == null) {
            PyTypeRenderer.$$$reportNull$$$0(22);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        if (this.isBitwiseOrUnionAvailable()) {
            result2.append(this.renderList(renderedUnionMembers, " | "));
        } else {
            result2.append(this.escaped("Union"));
            result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result2.append(this.renderList(renderedUnionMembers));
            result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(23);
        }
        return htmlChunk;
    }

    @NotNull
    private HtmlChunk renderOptional(@NotNull PyUnionType type2) {
        if (type2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(24);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        if (this.isBitwiseOrUnionAvailable()) {
            result2.append(this.render((PyType)ContainerUtil.find(type2.getMembers(), t -> !PyNoneTypeKt.isNoneType(t))));
            result2.append(this.styled(" | ", PyHighlighter.PY_OPERATION_SIGN));
            result2.append(this.render((PyType)ContainerUtil.find(type2.getMembers(), t -> PyNoneTypeKt.isNoneType(t))));
        } else {
            result2.append(this.escaped("Optional"));
            result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result2.append(this.render((PyType)ContainerUtil.find(type2.getMembers(), t -> !PyNoneTypeKt.isNoneType(t))));
            result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(25);
        }
        return htmlChunk;
    }

    private static @Nullable Pair<@NotNull List<PyLiteralType>, @NotNull List<PyType>> extractLiterals(@NotNull PyUnionType type2) {
        Collection<PyType> members;
        List literalTypes;
        if (type2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(26);
        }
        if ((literalTypes = ContainerUtil.filterIsInstance(members = type2.getMembers(), PyLiteralType.class)).size() < 2) {
            return null;
        }
        List otherTypes = ContainerUtil.filter(members, m -> !(m instanceof PyLiteralType));
        return Pair.create((Object)literalTypes, (Object)otherTypes);
    }

    private static boolean isOptional(@NotNull PyUnionType type2) {
        if (type2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(27);
        }
        return type2.getMembers().size() == 2 && ContainerUtil.find(type2.getMembers(), m -> PyNoneTypeKt.isNoneType(m)) != null;
    }

    @Override
    public HtmlChunk visitPyTupleType(@NotNull PyTupleType tupleType) {
        if (tupleType == null) {
            PyTypeRenderer.$$$reportNull$$$0(28);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        if (this.isGenericBuiltinsAvailable()) {
            result2.append(this.styled("tuple", PyHighlighter.PY_BUILTIN_NAME));
        } else {
            result2.append(this.escaped("Tuple"));
        }
        result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
        if (!tupleType.getElementTypes().isEmpty()) {
            result2.append(this.renderList(ContainerUtil.map(tupleType.getElementTypes(), this::render)));
            if (tupleType.isHomogeneous()) {
                result2.append(this.styled(", ", PyHighlighter.PY_COMMA));
                result2.append(this.styled("...", PyHighlighter.PY_DOT));
            }
        } else {
            result2.append(this.styled("()", PyHighlighter.PY_PARENTHS));
        }
        result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        return result2.toFragment();
    }

    @Override
    public HtmlChunk visitUnknownType() {
        return HtmlChunk.raw((String)"Any");
    }

    @Override
    public HtmlChunk visitPyType(@NotNull PyType type2) {
        if (type2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(29);
        }
        return this.escaped(type2.getName());
    }

    @Override
    public HtmlChunk visitPyCallableType(@NotNull PyCallableType callableType) {
        if (callableType == null) {
            PyTypeRenderer.$$$reportNull$$$0(30);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(this.styled("(", PyHighlighter.PY_PARENTHS));
        List<PyCallableParameter> parameters = callableType.getParameters(this.myTypeEvalContext);
        if (parameters != null) {
            result2.append(this.renderList(ContainerUtil.map(parameters, this::visitPyCallableParameter)));
        } else {
            result2.append(this.styled("...", PyHighlighter.PY_DOT));
        }
        result2.append(this.styled(")", PyHighlighter.PY_PARENTHS));
        result2.append(this.escaped(" -> "));
        result2.append(this.render(callableType.getReturnType(this.myTypeEvalContext)));
        return result2.toFragment();
    }

    @NotNull
    protected HtmlChunk visitPyCallableParameter(@NotNull PyCallableParameter param) {
        if (param == null) {
            PyTypeRenderer.$$$reportNull$$$0(31);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        PyType type2 = param.getType(this.myTypeEvalContext);
        if (!(type2 instanceof PyParamSpecType) && !(type2 instanceof PyConcatenateType) && param.getName() != null) {
            result2.append(this.styled(param.getName(), PyHighlighter.PY_PARAMETER));
            result2.append(this.styled(": ", PyHighlighter.PY_OPERATION_SIGN));
        }
        result2.append(this.render(type2));
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(32);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk renderList(@NotNull Collection<HtmlChunk> list) {
        if (list == null) {
            PyTypeRenderer.$$$reportNull$$$0(33);
        }
        HtmlChunk htmlChunk = this.renderList(list, ", ");
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(34);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk renderList(@NotNull Collection<HtmlChunk> list, @NotNull @Nls String separator) {
        if (list == null) {
            PyTypeRenderer.$$$reportNull$$$0(35);
        }
        if (separator == null) {
            PyTypeRenderer.$$$reportNull$$$0(36);
        }
        StreamEx streamEx = StreamEx.of(list);
        HtmlChunk htmlChunk = (HtmlChunk)streamEx.collect(HtmlChunk.toFragment((HtmlChunk)(switch (separator) {
            case ", " -> this.styled(separator, PyHighlighter.PY_COMMA);
            case " | " -> this.styled(separator, PyHighlighter.PY_OPERATION_SIGN);
            default -> this.escaped(separator);
        })));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(37);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    public HtmlChunk visitPyTypeVarType(@NotNull PyTypeVarType typeVarType) {
        if (typeVarType == null) {
            PyTypeRenderer.$$$reportNull$$$0(38);
        }
        HtmlChunk typeVarTypeRender = this.escaped(typeVarType.getName());
        HtmlChunk htmlChunk = typeVarType.isDefinition() ? this.wrapInTypingType(typeVarTypeRender) : typeVarTypeRender;
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(39);
        }
        return htmlChunk;
    }

    @Override
    public HtmlChunk visitPyTypeParameterType(@NotNull PyTypeParameterType typeParameterType) {
        if (typeParameterType == null) {
            PyTypeRenderer.$$$reportNull$$$0(40);
        }
        return this.escaped(typeParameterType.getName());
    }

    @Override
    @NotNull
    public HtmlChunk visitPySelfType(@NotNull PySelfType selfType) {
        if (selfType == null) {
            PyTypeRenderer.$$$reportNull$$$0(41);
        }
        HtmlChunk htmlChunk = this.className(selfType.getName());
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(42);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    public HtmlChunk visitPyCallableParameterListType(@NotNull PyCallableParameterListType callableParameterListType) {
        if (callableParameterListType == null) {
            PyTypeRenderer.$$$reportNull$$$0(43);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append("[");
        result2.append(this.renderList(ContainerUtil.map(callableParameterListType.getParameters(), this::visitPyCallableParameter)));
        result2.append("]");
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(44);
        }
        return htmlChunk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 8, 11, 13, 15, 18, 21, 23, 25, 32, 34, 37, 39, 42, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionOf";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceTypeRender";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "narrowedType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neverType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literals";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedUnionMembers";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableParameterListType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "styled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escaped";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "className";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "styledExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "renderGenericType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInTypingType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyClassLikeType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyNeverType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "renderUnionOfLiterals";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "renderUnion";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "renderOptional";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyCallableParameter";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "renderList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyTypeVarType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPySelfType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyCallableParameterListType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "styled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "styledExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPyGenericType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renderGenericType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapInTypingType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPyClassLikeType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNarrowedType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNeverType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitPyUnionType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "renderUnionOfLiterals";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "renderUnion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "renderOptional";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "extractLiterals";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isOptional";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTupleType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitPyType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableParameter";
                break;
            }
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "renderList";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeVarType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeParameterType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitPySelfType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableParameterListType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 8, 11, 13, 15, 18, 21, 23, 25, 32, 34, 37, 39, 42, 44 -> new IllegalStateException(string);
        };
    }

    public static final class TypeHint
    extends PyTypeRenderer {
        public TypeHint(@NotNull TypeEvalContext typeEvalContext) {
            if (typeEvalContext == null) {
                TypeHint.$$$reportNull$$$0(0);
            }
            super(typeEvalContext);
        }

        @Override
        protected boolean maxDepthExceeded() {
            return false;
        }

        @Override
        public HtmlChunk visitPyCallableType(@NotNull PyCallableType callableType) {
            if (callableType == null) {
                TypeHint.$$$reportNull$$$0(1);
            }
            HtmlBuilder result2 = new HtmlBuilder();
            result2.append(HtmlChunk.raw((String)"Callable"));
            result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result2.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            List<PyCallableParameter> parameters = callableType.getParameters(this.myTypeEvalContext);
            if (parameters != null) {
                result2.append(this.renderList(ContainerUtil.map(parameters, this::visitPyCallableParameter)));
            } else {
                result2.append(this.styled("...", PyHighlighter.PY_DOT));
            }
            result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
            result2.append(HtmlChunk.raw((String)", "));
            result2.append(this.render(callableType.getReturnType(this.myTypeEvalContext)));
            result2.append(this.styled("]", PyHighlighter.PY_BRACKETS));
            return result2.toFragment();
        }

        @Override
        @NotNull
        protected HtmlChunk visitPyCallableParameter(@NotNull PyCallableParameter param) {
            if (param == null) {
                TypeHint.$$$reportNull$$$0(2);
            }
            HtmlChunk htmlChunk = this.render(param.getType(this.myTypeEvalContext));
            if (htmlChunk == null) {
                TypeHint.$$$reportNull$$$0(3);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer$TypeHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer$TypeHint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPyCallableParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallableType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallableParameter";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class VerboseDocumentation
    extends PyTypeRenderer {
        VerboseDocumentation(@NotNull TypeEvalContext typeEvalContext) {
            if (typeEvalContext == null) {
                VerboseDocumentation.$$$reportNull$$$0(0);
            }
            super(typeEvalContext);
        }

        @Override
        @NotNull
        public HtmlChunk visitPyTypeVarType(@NotNull PyTypeVarType typeVarType) {
            if (typeVarType == null) {
                VerboseDocumentation.$$$reportNull$$$0(1);
            }
            HtmlBuilder result2 = new HtmlBuilder();
            typeVarType.getName();
            result2.append(this.escaped(typeVarType.getName()));
            PyType effectiveBound = PyTypeUtil.getEffectiveBound(typeVarType);
            if (effectiveBound != null) {
                result2.append(this.escaped(" \u2264: "));
                result2.append(this.render(effectiveBound));
            }
            HtmlChunk htmlChunk = typeVarType.isDefinition() ? this.wrapInTypingType(result2.toFragment()) : result2.toFragment();
            if (htmlChunk == null) {
                VerboseDocumentation.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVarType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer$VerboseDocumentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer$VerboseDocumentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPyTypeVarType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyTypeVarType";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static final class Documentation
    extends PyTypeRenderer {
        Documentation(@NotNull TypeEvalContext typeEvalContext) {
            if (typeEvalContext == null) {
                Documentation.$$$reportNull$$$0(0);
            }
            super(typeEvalContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeEvalContext", "com/jetbrains/python/documentation/PyTypeRenderer$Documentation", "<init>"));
        }
    }

    static final class RichDocumentation
    extends HtmlRenderer {
        RichDocumentation(@NotNull TypeEvalContext typeEvalContext, @NotNull PsiElement anchor) {
            if (typeEvalContext == null) {
                RichDocumentation.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                RichDocumentation.$$$reportNull$$$0(1);
            }
            super(typeEvalContext, anchor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/documentation/PyTypeRenderer$RichDocumentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class HtmlRenderer
    extends PyTypeRenderer {
        @NotNull
        private final PsiElement myAnchor;

        private HtmlRenderer(@NotNull TypeEvalContext typeEvalContext, @NotNull PsiElement anchor) {
            if (typeEvalContext == null) {
                HtmlRenderer.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                HtmlRenderer.$$$reportNull$$$0(1);
            }
            super(typeEvalContext);
            this.myAnchor = anchor;
        }

        @Override
        @NotNull
        protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
            if (style == null) {
                HtmlRenderer.$$$reportNull$$$0(2);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.styledSpan(text, style);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(3);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk escaped(@Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)text);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(4);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk className(@Nls String name2) {
            HtmlChunk htmlChunk = PyDocumentationLink.toPossibleClass(name2, this.myAnchor, this.myTypeEvalContext);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk styledExpression(@NotNull PyExpression expression) {
            if (expression == null) {
                HtmlRenderer.$$$reportNull$$$0(6);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.highlightExpressionText(expression.getText(), expression);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(7);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer$HtmlRenderer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer$HtmlRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escaped";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styledExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "styled";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "styledExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

