/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.Table;
import org.hsqldb.TypeInvariants;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class IndexStats {
    public static final IndexStats[] emptyArray = new IndexStats[0];
    public static final int sizes = 1;
    public static final int checkSpaces = 2;
    public static final int checkRows = 3;
    public static final int checkIndexSpaces = 4;
    public static final int setVersion = 5;
    public static final int findRoots = 6;
    public static final int fixAll = 8;
    public Index index;
    public PersistentStore store;
    public boolean hasErrors;
    public long errorCount;
    public long loopCount;
    public long goodRowCount;
    public boolean reindexed;
    HsqlArrayList unorderedList = new HsqlArrayList();

    public static Result newEmptyResult() {
        String[] stringArray = new String[]{"TABLE_NAME", "INDEX_NAME", "INFO"};
        Type[] typeArray = new Type[]{Type.SQL_VARCHAR_DEFAULT, TypeInvariants.SQL_IDENTIFIER, Type.SQL_VARCHAR_DEFAULT};
        Result result = Result.newMultiColumnResult(stringArray, typeArray);
        return result;
    }

    public void addTableStats(Result result) {
        Object[] objectArray = new Object[]{((Table)this.index.getTable()).getName().getSchemaQualifiedStatementName(), "", "rows " + this.store.elementCount()};
        result.navigator.add(objectArray);
    }

    public void addStats(Result result) {
        Object[] objectArray = new Object[]{((Table)this.index.getTable()).getName().getSchemaQualifiedStatementName(), this.index.getName().getStatementName(), "readable rows " + this.goodRowCount};
        result.navigator.add(objectArray);
        if (this.errorCount != 0L) {
            objectArray = new Object[]{"", "", "error rows " + this.errorCount};
            result.navigator.add(objectArray);
        }
        if (this.loopCount != 0L) {
            objectArray = new Object[]{"", "", "loop rows " + this.loopCount};
            result.navigator.add(objectArray);
        }
        for (int i = 0; i < this.unorderedList.size(); ++i) {
            Object[] objectArray2 = new Object[]{"", "", this.unorderedList.get(i)};
            result.navigator.add(objectArray2);
        }
    }

    public void addReindexedStats(Result result) {
        Object[] objectArray = new Object[]{((Table)this.index.getTable()).getName().getSchemaQualifiedStatementName(), this.index.getName().getStatementName(), "reindexed"};
        result.navigator.add(objectArray);
    }
}

