#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-IPTzTHFGYnfA5tse8j4As0
key:                  hledger-web-1.43.1-IPTzTHFGYnfA5tse8j4As0
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  57648a27dc4bc7e84c7f6f578f9b96c1
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-IPTzTHFGYnfA5tse8j4As0
depends:
    Decimal-0.5.2-6dDYqkIQ9zB52LXEjPIhQL
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne base-4.17.2.1
    base64-1.0-JAbuKlyjvHXLNSnnjE79PD
    blaze-html-0.9.2.0-6FdDEpkzFvJ8vV2dWWNvLM
    blaze-markup-0.8.3.0-4eOecTxNwixJj4g2MNGecA bytestring-0.11.5.3
    case-insensitive-1.2.1.0-42k9iOSknrb4MqDPwxdyM4
    clientsession-0.9.3.0-L1tnjxRdk2t5wILNtzMCYv
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-2pVpKBDXmhu8qGH9ehT40y
    conduit-extra-1.3.8-6EmNFogxH9m3yVrdAYfwkX containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-EUCiKuF8A8QJZrcHdWAV4o
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-HPn8TtP68ADBPjzHJuZtHu
    hjsmin-0.2.1-H5G42op4Cbt4ivJVYa4e0
    hledger-1.43.1-21HRveQ58YCGwwcfKMxs57
    hledger-lib-1.43.1-DfLm6kGWyTLAO4rcUZwgKK
    hspec-2.11.3-JM11SHVgmYdBtXuu7EThN1
    http-client-0.7.19-CGIiAJO6qfCADepj1ASGVk
    http-conduit-2.3.9.1-1ZtBudtkVKQHTNrIHwzYXd
    http-types-0.12.4-7VKWb71irDD4uKtGM0MrBb
    megaparsec-9.7.0-1JRkSOE0CLKI56z4E4coO3 mtl-2.2.2
    network-3.1.4.0-IC0hdE8eZqJ6PeeNglfLy3
    safe-0.3.21-Bbk2Vieba7fJdNA7Fx2QS4
    shakespeare-2.1.7-IlJSHjcf6uhKohbw1liaMl template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-CmOIYoDybN9DOhK0mZM0Em
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-9UOcSkHEAzRImuC2gWdKbJ
    wai-cors-0.2.7-CTrIkgypWRxCLdb2PwMaQW
    wai-extra-3.1.18-IyZc7VwwIQRd2Hz2VWBa4
    wai-handler-launch-3.0.3.1-FmkPXFJIMRkwsuZjxlvAp
    warp-3.4.0-ElI89jnrDVYITHcf4bOOtL
    yaml-0.11.11.2-86vh7a5da508VmYUUJ1GSC
    yesod-1.6.2.1-Hcqjg3b05f2IrECf9I7MTU
    yesod-core-1.6.27.1-1gRH9td2xXqGYRflIOWNYJ
    yesod-form-1.7.9-1gdnwH435lCBjPv1C56PpA
    yesod-static-1.6.1.0-LvW5hSNLClSLMCAFZ77rQN
    yesod-test-1.6.23-6OnbgxiciRG1MUWzHhxWeU

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

