#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-21HRveQ58YCGwwcfKMxs57
key:                  hledger-1.43.1-21HRveQ58YCGwwcfKMxs57
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  71d3357ad59d3e3f160fcded00a58164
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-21HRveQ58YCGwwcfKMxs57
depends:
    Decimal-0.5.2-6dDYqkIQ9zB52LXEjPIhQL
    Diff-0.5-Iz6Klc6Zm5z1jTIw09K3iw aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    ansi-terminal-1.0.2-EPVLF4zwBLpAhuvD3wgQPr base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-EUCiKuF8A8QJZrcHdWAV4o
    filepath-1.4.2.2 githash-0.1.6.3-HPn8TtP68ADBPjzHJuZtHu
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko haskeline-0.8.2
    hledger-lib-1.43.1-DfLm6kGWyTLAO4rcUZwgKK
    http-client-0.7.19-CGIiAJO6qfCADepj1ASGVk
    http-types-0.12.4-7VKWb71irDD4uKtGM0MrBb
    lucid-2.11.20250303-HpQAOqJxOaDFRL8O0eNi1v
    math-functions-0.3.4.4-Fh4MI4RdNPf9U0T3g6DnjH
    megaparsec-9.7.0-1JRkSOE0CLKI56z4E4coO3
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-HKXZloQwfv9Egc4x8n0DDu mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.5-3jfIfS23fhoC4PyiafLhmq
    req-3.13.4-Gl2VrjAbquHK0sa5LcdHX9
    safe-0.3.21-Bbk2Vieba7fJdNA7Fx2QS4
    shakespeare-2.1.7-IlJSHjcf6uhKohbw1liaMl
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-B689U0Xm4QDHcYXCcywU8t
    temporary-1.3-Jo3GPHqXt7U7op7E9Rmxl4 text-2.0.2
    text-ansi-0.3.0.1-C3Iu4Bh9lC04KgoTjri6gc time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-HR3NhfwsNhgHWAh3bVdqZd
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

