#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 network-uri
version:              2.6.4.2
visibility:           public
id:                   network-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
key:                  network-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
license:              BSD-3-Clause
maintainer:           ezra@ezrakilty.net
homepage:             https://github.com/haskell/network-uri
synopsis:             URI manipulation
description:
    This package provides facilities for parsing and unparsing URIs, and creating
    and resolving relative URI references, closely following the URI spec,
    <http://www.ietf.org/rfc/rfc3986.txt IETF RFC 3986>.

    == Backward-compatibility

    In @network-2.6@ the "Network.URI" module was split off from the
    @network@ package into this package. If you'\''re using the "Network.URI"
    module you can be backward compatible and automatically get it from
    the right package by using the
    </package/network-uri-flag network-uri-flag pseudo-package>
    in your @.cabal@ file'\''s build-depends (along with dependencies for
    both @network-uri@ and @network@):

    >  build-depends:
    >     network-uri-flag == 0.1.*

    Or you can do the same manually by adding this boilerplate to your
    @.cabal@ file:

    > flag network-uri
    >   description: Get Network.URI from the network-uri package
    >   default: True
    >
    > library
    >   -- ...
    >   if flag(network-uri)
    >     build-depends: network-uri >= 2.6, network >= 2.6
    >   else
    >     build-depends: network-uri < 2.6, network < 2.6

    That is, get the module from either @network < 2.6@ or from
    @network-uri >= 2.6@.

category:             Network
abi:                  b0babaea8fb11a77507534d2a797242f
exposed:              True
exposed-modules:      Network.URI Network.URI.Lens Network.URI.Static
import-dirs:          /usr/lib/ghc-9.4.8/site-local/network-uri-2.6.4.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/network-uri-2.6.4.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/network-uri-2.6.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-network-uri
hs-libraries:         HSnetwork-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
depends:
    base-4.17.2.1 deepseq-1.4.8.0 parsec-3.1.16.1
    template-haskell-2.19.0.0 th-compat-0.1.6-AAuXhVZS4q5CGhWSVhEnzd

haddock-interfaces:   /usr/share/doc/haskell-network-uri/html/network-uri.haddock
haddock-html:         /usr/share/doc/haskell-network-uri/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

