/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.FontMetrics;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CombinedConditions;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConjunctConditions
extends CombinedConditions
implements ICombinedCondition {
    static final String NAME = "conjunct_condition";
    private final ASelectableCondition[] conditions;

    public static ConjunctConditions combine(ASelectableCondition ... conditions) {
        return new ConjunctConditions(CombinedConditions.combine(ConjunctConditions.class, conditions));
    }

    static ASelectableCondition load(ConditionFactory conditionFactory, XMLElement element) {
        ASelectableCondition[] conditions = ConjunctConditions.loadConditions(conditionFactory, element);
        return new ConjunctConditions(conditions);
    }

    ConjunctConditions(ASelectableCondition ... conditions) {
        this.conditions = conditions;
    }

    @Override
    protected ASelectableCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        for (ASelectableCondition condition : this.conditions) {
            if (condition.checkNode(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        return this.createRenderedIcons("filter_and", fontMetrics);
    }

    @Override
    public boolean canBePersisted() {
        return Stream.of(this.conditions).allMatch(ASelectableCondition::canBePersisted);
    }

    @Override
    public void fillXML(XMLElement child) {
        for (ASelectableCondition condition : this.conditions) {
            condition.toXml(child);
        }
    }

    @Override
    protected String createDescription() {
        return this.createDescription("filter_and");
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public Collection<ASelectableCondition> split() {
        return Arrays.asList(this.conditions);
    }

    @Override
    protected ASelectableCondition createConditions(ASelectableCondition[] newConditions) {
        return new ConjunctConditions(newConditions);
    }
}

