/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SingleColumnTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = null;
    private List<String> lines = new ArrayList<String>();
    private boolean editable = true;

    public SingleColumnTableModel(String columnName) {
        this.columnNames = new String[]{columnName};
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.lines.get(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.editable) {
            this.lines.set(row, (String)value);
            this.checkAndAppendNewRow();
            this.fireTableCellUpdated(row, col);
        }
    }

    public List<String> getLines() {
        ArrayList<String> newList = new ArrayList<String>(this.lines);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals("")) continue;
            it.remove();
        }
        return newList;
    }

    public void setLines(List<String> lines) {
        this.lines = lines == null ? new ArrayList<String>() : new ArrayList<String>(lines);
        if (this.editable) {
            this.checkAndAppendNewRow();
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    private void checkAndAppendNewRow() {
        String auth = null;
        if (this.lines.size() > 0) {
            auth = this.lines.get(this.lines.size() - 1);
            if (!auth.equals("")) {
                auth = "";
                this.lines.add(auth);
            }
        } else {
            auth = "";
            this.lines.add(auth);
        }
    }

    public Class<String> getColumnClass(int c) {
        return String.class;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

