/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.jasper.compiler.Localizer;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class UniqueAttributesImpl
extends AttributesImpl {
    private static final String IMPORT = "import";
    private static final String PAGE_ENCODING = "pageEncoding";
    private final boolean pageDirective;
    private final Set<String> qNames = new HashSet<String>();

    public UniqueAttributesImpl() {
        this.pageDirective = false;
    }

    public UniqueAttributesImpl(boolean bl) {
        this.pageDirective = bl;
    }

    @Override
    public void clear() {
        this.qNames.clear();
        super.clear();
    }

    @Override
    public void setAttributes(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (this.qNames.add(attributes.getQName(i))) continue;
            this.handleDuplicate(attributes.getQName(i), attributes.getValue(i));
        }
        super.setAttributes(attributes);
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this.qNames.add(string3)) {
            super.addAttribute(string, string2, string3, string4, string5);
        } else {
            this.handleDuplicate(string3, string5);
        }
    }

    @Override
    public void setAttribute(int n, String string, String string2, String string3, String string4, String string5) {
        this.qNames.remove(super.getQName(n));
        if (this.qNames.add(string3)) {
            super.setAttribute(n, string, string2, string3, string4, string5);
        } else {
            this.handleDuplicate(string3, string5);
        }
    }

    @Override
    public void removeAttribute(int n) {
        this.qNames.remove(super.getQName(n));
        super.removeAttribute(n);
    }

    @Override
    public void setQName(int n, String string) {
        this.qNames.remove(super.getQName(n));
        super.setQName(n, string);
    }

    private void handleDuplicate(String string, String string2) {
        if (this.pageDirective) {
            String string3;
            if (IMPORT.equalsIgnoreCase(string)) {
                int n = super.getIndex(IMPORT);
                String string4 = super.getValue(n);
                super.setValue(n, string4 + "," + string2);
                return;
            }
            if (!PAGE_ENCODING.equalsIgnoreCase(string) && (string3 = super.getValue(string)).equals(string2)) {
                return;
            }
        }
        throw new IllegalArgumentException(Localizer.getMessage("jsp.error.duplicateqname", string));
    }
}

