
use builtin;
use str;

set edit:completion:arg-completer[starship] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'starship'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'starship'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand bug-report 'Create a pre-populated GitHub issue with information about your configuration'
            cand completions 'Generate starship shell completions for your shell to stdout'
            cand config 'Edit the starship configuration'
            cand explain 'Explains the currently showing modules'
            cand init 'Prints the shell function used to execute starship'
            cand module 'Prints a specific prompt module'
            cand preset 'Prints a preset config'
            cand print-config 'Prints the computed starship configuration'
            cand prompt 'Prints the full starship prompt'
            cand session 'Generate random session key'
            cand time 'Prints time in milliseconds'
            cand timings 'Prints timings of all active modules'
            cand toggle 'Toggle a given starship module'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'starship;bug-report'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;completions'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;config'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;explain'= {
            cand -s 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --status 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --pipestatus 'Bash, Fish and Zsh support returning codes for each process in a pipeline'
            cand -w 'The width of the current interactive terminal'
            cand --terminal-width 'The width of the current interactive terminal'
            cand -p 'The path that the prompt should render for'
            cand --path 'The path that the prompt should render for'
            cand -P 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand --logical-path 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand -d 'The execution duration of the last command, in milliseconds'
            cand --cmd-duration 'The execution duration of the last command, in milliseconds'
            cand -k 'The keymap of fish/zsh/cmd'
            cand --keymap 'The keymap of fish/zsh/cmd'
            cand -j 'The number of currently running jobs'
            cand --jobs 'The number of currently running jobs'
            cand --shlvl 'The current value of SHLVL, for shells that mis-handle it in $()'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;init'= {
            cand --print-full-init 'print-full-init'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;module'= {
            cand -s 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --status 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --pipestatus 'Bash, Fish and Zsh support returning codes for each process in a pipeline'
            cand -w 'The width of the current interactive terminal'
            cand --terminal-width 'The width of the current interactive terminal'
            cand -p 'The path that the prompt should render for'
            cand --path 'The path that the prompt should render for'
            cand -P 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand --logical-path 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand -d 'The execution duration of the last command, in milliseconds'
            cand --cmd-duration 'The execution duration of the last command, in milliseconds'
            cand -k 'The keymap of fish/zsh/cmd'
            cand --keymap 'The keymap of fish/zsh/cmd'
            cand -j 'The number of currently running jobs'
            cand --jobs 'The number of currently running jobs'
            cand --shlvl 'The current value of SHLVL, for shells that mis-handle it in $()'
            cand -l 'List out all supported modules'
            cand --list 'List out all supported modules'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;preset'= {
            cand -o 'Output the preset to a file instead of stdout'
            cand --output 'Output the preset to a file instead of stdout'
            cand -l 'List out all preset names'
            cand --list 'List out all preset names'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;print-config'= {
            cand -d 'Print the default instead of the computed config'
            cand --default 'Print the default instead of the computed config'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;prompt'= {
            cand --profile 'Print the prompt with the specified profile name (instead of the standard left prompt)'
            cand -s 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --status 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --pipestatus 'Bash, Fish and Zsh support returning codes for each process in a pipeline'
            cand -w 'The width of the current interactive terminal'
            cand --terminal-width 'The width of the current interactive terminal'
            cand -p 'The path that the prompt should render for'
            cand --path 'The path that the prompt should render for'
            cand -P 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand --logical-path 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand -d 'The execution duration of the last command, in milliseconds'
            cand --cmd-duration 'The execution duration of the last command, in milliseconds'
            cand -k 'The keymap of fish/zsh/cmd'
            cand --keymap 'The keymap of fish/zsh/cmd'
            cand -j 'The number of currently running jobs'
            cand --jobs 'The number of currently running jobs'
            cand --shlvl 'The current value of SHLVL, for shells that mis-handle it in $()'
            cand --right 'Print the right prompt (instead of the standard left prompt)'
            cand --continuation 'Print the continuation prompt (instead of the standard left prompt)'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;session'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;time'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;timings'= {
            cand -s 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --status 'The status code of the previously run command as an unsigned or signed 32bit integer'
            cand --pipestatus 'Bash, Fish and Zsh support returning codes for each process in a pipeline'
            cand -w 'The width of the current interactive terminal'
            cand --terminal-width 'The width of the current interactive terminal'
            cand -p 'The path that the prompt should render for'
            cand --path 'The path that the prompt should render for'
            cand -P 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand --logical-path 'The logical path that the prompt should render for. This path should be a virtual/logical representation of the PATH argument'
            cand -d 'The execution duration of the last command, in milliseconds'
            cand --cmd-duration 'The execution duration of the last command, in milliseconds'
            cand -k 'The keymap of fish/zsh/cmd'
            cand --keymap 'The keymap of fish/zsh/cmd'
            cand -j 'The number of currently running jobs'
            cand --jobs 'The number of currently running jobs'
            cand --shlvl 'The current value of SHLVL, for shells that mis-handle it in $()'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;toggle'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'starship;help'= {
            cand bug-report 'Create a pre-populated GitHub issue with information about your configuration'
            cand completions 'Generate starship shell completions for your shell to stdout'
            cand config 'Edit the starship configuration'
            cand explain 'Explains the currently showing modules'
            cand init 'Prints the shell function used to execute starship'
            cand module 'Prints a specific prompt module'
            cand preset 'Prints a preset config'
            cand print-config 'Prints the computed starship configuration'
            cand prompt 'Prints the full starship prompt'
            cand session 'Generate random session key'
            cand time 'Prints time in milliseconds'
            cand timings 'Prints timings of all active modules'
            cand toggle 'Toggle a given starship module'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'starship;help;bug-report'= {
        }
        &'starship;help;completions'= {
        }
        &'starship;help;config'= {
        }
        &'starship;help;explain'= {
        }
        &'starship;help;init'= {
        }
        &'starship;help;module'= {
        }
        &'starship;help;preset'= {
        }
        &'starship;help;print-config'= {
        }
        &'starship;help;prompt'= {
        }
        &'starship;help;session'= {
        }
        &'starship;help;time'= {
        }
        &'starship;help;timings'= {
        }
        &'starship;help;toggle'= {
        }
        &'starship;help;help'= {
        }
    ]
    $completions[$command]
}
