/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.sql.SqlKind;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchAggregateIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchAggregateIndexScanRule
extends RelRule<Config> {
    protected OpenSearchAggregateIndexScanRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length == 3) {
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
            LogicalProject project = (LogicalProject)call.rel(1);
            CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(2);
            this.apply(call, aggregate, project, scan);
        } else if (call.rels.length == 2) {
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
            CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
            this.apply(call, aggregate, null, scan);
        } else {
            throw new AssertionError((Object)String.format("The length of rels should be %s but got %s", this.operands.size(), call.rels.length));
        }
    }

    protected void apply(RelOptRuleCall call, LogicalAggregate aggregate, LogicalProject project, CalciteLogicalIndexScan scan) {
        CalciteLogicalIndexScan newScan = scan.pushDownAggregate(aggregate, project);
        if (newScan != null) {
            call.transformTo(newScan);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchAggregateIndexScanRule.Config.builder().build().withDescription("Agg-Project-TableScan").withOperandSupplier(b0 -> b0.operand(LogicalAggregate.class).predicate(agg -> agg.getAggCallList().stream().noneMatch(AggregateCall::hasFilter)).oneInput(b1 -> b1.operand(LogicalProject.class).predicate(Predicate.not(OpenSearchIndexScanRule::containsRexOver).and(OpenSearchIndexScanRule::distinctProjectList)).oneInput(b2 -> b2.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(OpenSearchIndexScanRule::isLimitPushed).and(OpenSearchIndexScanRule::noAggregatePushed)).noInputs())));
        public static final Config COUNT_STAR = ImmutableOpenSearchAggregateIndexScanRule.Config.builder().build().withDescription("Agg[count()]-TableScan").withOperandSupplier(b0 -> b0.operand(LogicalAggregate.class).predicate(agg -> agg.getGroupSet().isEmpty() && agg.getAggCallList().stream().allMatch(call -> call.getAggregation().kind == SqlKind.COUNT && call.getArgList().isEmpty() && !call.hasFilter())).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(OpenSearchIndexScanRule::isLimitPushed).and(OpenSearchIndexScanRule::noAggregatePushed)).noInputs()));

        @Override
        default public OpenSearchAggregateIndexScanRule toRule() {
            return new OpenSearchAggregateIndexScanRule(this);
        }
    }
}

