/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.opensearch.sql.utils.DateTimeFormatters;

public interface DateTimeParser {
    public static LocalDateTime parse(String input) {
        try {
            return LocalDateTime.parse(input, DateTimeFormatters.DATE_TIMESTAMP_FORMATTER);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalTime t2 = LocalTime.parse(input, DateTimeFormatters.TIME_TIMESTAMP_FORMATTER);
                return LocalDateTime.of(LocalDate.now(ZoneId.of("UTC")), t2);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "timestamp:%s in unsupported format, please use 'yyyy-MM-dd HH:mm:ss[.SSSSSSSSS]'", input));
            }
        }
    }
}

