/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MessageInput
implements ToXContentObject,
Writeable {
    private String role;
    private String content;

    public MessageInput(String role, String content) {
        if (StringUtils.isBlank(content)) {
            throw new IllegalArgumentException("Content is required");
        }
        this.role = role;
        this.content = content;
    }

    public MessageInput(StreamInput in) throws IOException {
        this.role = in.readOptionalString();
        this.content = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.role);
        out.writeString(this.content);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.role != null) {
            builder.field("role", this.role);
        }
        builder.field("content", this.content);
        builder.endObject();
        return builder;
    }

    public static MessageInput parse(XContentParser parser) throws IOException {
        String role = null;
        String content = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "role": {
                    role = parser.text();
                    continue block8;
                }
                case "content": {
                    content = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MessageInput(role, content);
    }

    @Generated
    public static MessageInputBuilder builder() {
        return new MessageInputBuilder();
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public static class MessageInputBuilder {
        @Generated
        private String role;
        @Generated
        private String content;

        @Generated
        MessageInputBuilder() {
        }

        @Generated
        public MessageInputBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MessageInputBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public MessageInput build() {
            return new MessageInput(this.role, this.content);
        }

        @Generated
        public String toString() {
            return "MessageInput.MessageInputBuilder(role=" + this.role + ", content=" + this.content + ")";
        }
    }
}

