/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;

public class MLModelGroup
implements ToXContentObject {
    public static final String MODEL_GROUP_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String LATEST_VERSION_FIELD = "latest_version";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String OWNER = "owner";
    public static final String ACCESS = "access";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private String name;
    private String description;
    private int latestVersion;
    private List<String> backendRoles;
    private User owner;
    private String access;
    private String modelGroupId;
    private Instant createdTime;
    private Instant lastUpdatedTime;
    private String tenantId;

    public MLModelGroup(String name, String description2, int latestVersion, List<String> backendRoles, User owner, String access, String modelGroupId, Instant createdTime, Instant lastUpdatedTime, String tenantId) {
        this.name = Objects.requireNonNull(name, "model group name must not be null");
        this.description = description2;
        this.latestVersion = latestVersion;
        this.backendRoles = backendRoles;
        this.owner = owner;
        this.access = access;
        this.modelGroupId = modelGroupId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.tenantId = tenantId;
    }

    public MLModelGroup(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readString();
        this.description = input.readOptionalString();
        this.latestVersion = input.readInt();
        if (input.readBoolean()) {
            this.backendRoles = input.readStringList();
        }
        this.owner = input.readBoolean() ? new User(input) : null;
        this.access = input.readOptionalString();
        this.modelGroupId = input.readOptionalString();
        this.createdTime = input.readOptionalInstant();
        this.lastUpdatedTime = input.readOptionalInstant();
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        out.writeInt(this.latestVersion);
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.access);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdatedTime);
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_GROUP_NAME_FIELD, this.name);
        builder.field(LATEST_VERSION_FIELD, this.latestVersion);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.owner != null) {
            builder.field(OWNER, (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field(ACCESS, this.access);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime.toEpochMilli());
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLModelGroup parse(XContentParser parser) throws IOException {
        String name = null;
        String description2 = null;
        ArrayList<String> backendRoles = null;
        int latestVersion = 0;
        User owner = null;
        String access = null;
        String modelGroupId = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block24;
                }
                case "description": {
                    description2 = parser.text();
                    continue block24;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block24;
                }
                case "latest_version": {
                    latestVersion = parser.intValue();
                    continue block24;
                }
                case "owner": {
                    owner = User.parse(parser);
                    continue block24;
                }
                case "access": {
                    access = parser.text();
                    continue block24;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block24;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return MLModelGroup.builder().name(name).description(description2).backendRoles(backendRoles).latestVersion(latestVersion).owner(owner).access(access).modelGroupId(modelGroupId).createdTime(createdTime).lastUpdatedTime(lastUpdateTime).tenantId(tenantId).build();
    }

    public static MLModelGroup fromStream(StreamInput in) throws IOException {
        return new MLModelGroup(in);
    }

    @Generated
    public static MLModelGroupBuilder builder() {
        return new MLModelGroupBuilder();
    }

    @Generated
    public MLModelGroupBuilder toBuilder() {
        return new MLModelGroupBuilder().name(this.name).description(this.description).latestVersion(this.latestVersion).backendRoles(this.backendRoles).owner(this.owner).access(this.access).modelGroupId(this.modelGroupId).createdTime(this.createdTime).lastUpdatedTime(this.lastUpdatedTime).tenantId(this.tenantId);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Generated
    public String getAccess() {
        return this.access;
    }

    @Generated
    public String getModelGroupId() {
        return this.modelGroupId;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public static class MLModelGroupBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private int latestVersion;
        @Generated
        private List<String> backendRoles;
        @Generated
        private User owner;
        @Generated
        private String access;
        @Generated
        private String modelGroupId;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private String tenantId;

        @Generated
        MLModelGroupBuilder() {
        }

        @Generated
        public MLModelGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLModelGroupBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public MLModelGroupBuilder latestVersion(int latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        @Generated
        public MLModelGroupBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLModelGroupBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public MLModelGroupBuilder access(String access) {
            this.access = access;
            return this;
        }

        @Generated
        public MLModelGroupBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        @Generated
        public MLModelGroupBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLModelGroupBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLModelGroupBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLModelGroup build() {
            return new MLModelGroup(this.name, this.description, this.latestVersion, this.backendRoles, this.owner, this.access, this.modelGroupId, this.createdTime, this.lastUpdatedTime, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLModelGroup.MLModelGroupBuilder(name=" + this.name + ", description=" + this.description + ", latestVersion=" + this.latestVersion + ", backendRoles=" + String.valueOf(this.backendRoles) + ", owner=" + String.valueOf(this.owner) + ", access=" + this.access + ", modelGroupId=" + this.modelGroupId + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

