/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DumpInfo {
    private static final String[] classes = new String[]{FipsAES.class.getName(), FipsTripleDES.class.getName(), FipsDH.class.getName(), FipsSHS.class.getName(), FipsDRBG.class.getName(), FipsDSA.class.getName(), FipsEC.class.getName(), FipsKDF.class.getName(), FipsPBKD.class.getName(), FipsRSA.class.getName()};

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-c")) {
                System.out.println(Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
                System.err.println("Generated new HMAC");
            } else if (stringArray[0].equals("-a") && stringArray.length > 1) {
                try {
                    JarFile jarFile = new JarFile(stringArray[1]);
                    System.out.println(Strings.fromByteArray(Hex.encode(DumpInfo.calculateModuleHMAC(jarFile))));
                    System.err.println("Generated new HMAC for Jar file " + stringArray[1]);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to open Jar file " + stringArray[1]);
                }
            } else {
                System.err.println("Invalid command line arguments.");
            }
        } else {
            DumpInfo.runTests();
            System.out.println("Version Info: " + new BouncyCastleFipsProvider().getInfo());
            System.out.println("FIPS Ready Status: " + FipsStatus.getStatusMessage());
            System.out.println("Module SHA-256 HMAC: " + Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object;
            OutputMACCalculator outputMACCalculator = new FipsSHS.MACOperatorFactory().createOutputMACCalculator((SymmetricKey)new SymmetricSecretKey(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle Inc.")), FipsSHS.SHA256_HMAC);
            UpdateOutputStream updateOutputStream = outputMACCalculator.getMACStream();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object2 = jarFile.entries();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (((ZipEntry)object).isDirectory() || ((ZipEntry)object).getName().startsWith("META-INF/") && ((ZipEntry)object).getName().indexOf("versions") < 0 || ((ZipEntry)object).getName().indexOf("module-info.class") > 0) continue;
                treeMap.put(((ZipEntry)object).getName(), object);
            }
            object2 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream2 = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                updateOutputStream.update((byte)91);
                updateOutputStream.update(byArray, 0, byArray.length);
                updateOutputStream.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                updateOutputStream.update((byte)93);
                while ((n = inputStream2.read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                    updateOutputStream.update((byte[])object2, 0, n);
                }
                inputStream2.close();
            }
            updateOutputStream.update((byte)91);
            object = Strings.toUTF8ByteArray("END");
            updateOutputStream.update((byte[])object, 0, ((Object)object).length);
            updateOutputStream.update((byte)93);
            updateOutputStream.close();
            return outputMACCalculator.getMAC();
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static void runTests() {
        for (String string : classes) {
            if (FipsStatus.isErrorStatus()) continue;
            DumpInfo.loadClass(string);
        }
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }
}

