/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlScopedShuttle
extends SqlShuttle {
    private final Deque<SqlValidatorScope> scopes = new ArrayDeque<SqlValidatorScope>();

    protected SqlScopedShuttle(SqlValidatorScope initialScope) {
        this.scopes.push(initialScope);
    }

    @Override
    public final @Nullable SqlNode visit(SqlCall call) {
        SqlValidatorScope oldScope = this.getScope();
        SqlValidatorScope newScope = oldScope.getOperandScope(call);
        this.scopes.push(newScope);
        SqlNode result2 = this.visitScoped(call);
        this.scopes.pop();
        return result2;
    }

    protected @Nullable SqlNode visitScoped(SqlCall call) {
        return super.visit(call);
    }

    protected SqlValidatorScope getScope() {
        return Objects.requireNonNull(this.scopes.peek(), "scopes.peek()");
    }
}

