/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.function.Function;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.LambdaExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Lists;

public final class FunctionExpression<F extends Function<?>>
extends LambdaExpression {
    public final @Nullable F function;
    public final @Nullable BlockStatement body;
    public final List<ParameterExpression> parameterList;
    private @Nullable F dynamicFunction;
    private int hash;

    private FunctionExpression(Class<F> type2, @Nullable F function, @Nullable BlockStatement body, List<ParameterExpression> parameterList) {
        super(ExpressionType.Lambda, type2);
        if (function == null && body == null) {
            throw new IllegalArgumentException("both function and body should not be null");
        }
        this.function = function;
        this.body = body;
        this.parameterList = Objects.requireNonNull(parameterList, "parameterList");
    }

    public FunctionExpression(F function) {
        this(function.getClass(), function, null, ImmutableList.of());
    }

    public FunctionExpression(Class<F> type2, BlockStatement body, List<ParameterExpression> parameters2) {
        this(type2, null, body, parameters2);
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body == null ? null : this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    public Invokable compile() {
        return args2 -> {
            Evaluator evaluator = new Evaluator();
            for (int i = 0; i < args2.length; ++i) {
                evaluator.push(this.parameterList.get(i), args2[i]);
            }
            return evaluator.evaluate(Objects.requireNonNull(this.body, "body"));
        };
    }

    public F getFunction() {
        if (this.function != null) {
            return this.function;
        }
        if (this.dynamicFunction == null) {
            Invokable x = this.compile();
            ClassLoader classLoader = Objects.requireNonNull(this.getClass().getClassLoader());
            this.dynamicFunction = (Function)Proxy.newProxyInstance(classLoader, new Class[]{Types.toClass(this.type)}, (proxy, method, args2) -> x.dynamicInvoke(args2));
        }
        return this.dynamicFunction;
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        String bridgeResultTypeName;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> bridgeParams = new ArrayList<String>();
        ArrayList<String> bridgeArgs = new ArrayList<String>();
        ArrayList<String> boxBridgeParams = new ArrayList<String>();
        ArrayList<String> boxBridgeArgs = new ArrayList<String>();
        for (ParameterExpression parameterExpression : this.parameterList) {
            Type parameterType = parameterExpression.getType();
            Type parameterBoxType = Types.box(parameterType);
            String parameterBoxTypeName = Types.className(parameterBoxType);
            params.add(parameterExpression.declString());
            bridgeParams.add(parameterExpression.declString((Type)((Object)Object.class)));
            bridgeArgs.add("(" + parameterBoxTypeName + ") " + parameterExpression.name);
            boxBridgeParams.add(parameterExpression.declString(parameterBoxType));
            boxBridgeArgs.add(parameterExpression.name + (Primitive.is(parameterType) ? "." + Objects.requireNonNull(Primitive.of((Type)parameterType)).primitiveName + "Value()" : ""));
        }
        Objects.requireNonNull(this.body, "body");
        Type bridgeResultType = Functions.FUNCTION_RESULT_TYPES.get(this.type);
        if (bridgeResultType == null) {
            bridgeResultType = this.body.getType();
        }
        Type resultType2 = bridgeResultType;
        if (bridgeResultType == Object.class && !params.equals(bridgeParams) && !(this.body.getType() instanceof TypeVariable)) {
            resultType2 = this.body.getType();
        }
        String methodName = this.getAbstractMethodName();
        writer.append("new ").append(this.type).append("()").begin(" {\n").append("public ").append(Types.className(resultType2)).list(" " + methodName + "(", ", ", ") ", params).append(Blocks.toFunctionBlock(this.body));
        String string = bridgeResultTypeName = this.isAbstractMethodPrimitive() ? Types.className(bridgeResultType) : Types.className(Types.box(bridgeResultType));
        if (!boxBridgeParams.equals(params)) {
            writer.append("public ").append(bridgeResultTypeName).list(" " + methodName + "(", ", ", ") ", boxBridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", boxBridgeArgs).end("}\n");
        }
        if (!bridgeParams.equals(params)) {
            writer.append("public ").append(bridgeResultTypeName).list(" " + methodName + "(", ", ", ") ", bridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", bridgeArgs).end("}\n");
        }
        writer.end("}\n");
    }

    private boolean isAbstractMethodPrimitive() {
        Method method = this.getAbstractMethod();
        return Primitive.is(method.getReturnType());
    }

    private String getAbstractMethodName() {
        Method abstractMethod = this.getAbstractMethod();
        return abstractMethod.getName();
    }

    private Method getAbstractMethod() {
        if (this.type instanceof Class && ((Class)this.type).isInterface()) {
            ArrayList<Method> declaredMethods = Lists.newArrayList(((Class)this.type).getDeclaredMethods());
            declaredMethods.removeIf(m4 -> (m4.getModifiers() & 0x1000) != 0);
            if (declaredMethods.size() == 1) {
                return (Method)declaredMethods.get(0);
            }
        }
        throw new IllegalStateException("Method not found, type = " + this.type);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionExpression that = (FunctionExpression)o;
        return Objects.equals(this.body, that.body) && Objects.equals(this.function, that.function) && this.parameterList.equals(that.parameterList);
    }

    @Override
    public int hashCode() {
        int result2 = this.hash;
        if (result2 == 0) {
            result2 = Objects.hash(new Object[]{this.nodeType, this.type, this.function, this.body, this.parameterList});
            if (result2 == 0) {
                result2 = 1;
            }
            this.hash = result2;
        }
        return result2;
    }

    public static interface Invokable {
        public @Nullable Object dynamicInvoke(Object ... var1);
    }
}

