/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.emrserverless.model.CloudWatchLoggingConfiguration;
import java.util.Map;

@SdkInternalApi
public class CloudWatchLoggingConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").build();
    private static final MarshallingInfo<String> LOGSTREAMNAMEPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamNamePrefix").build();
    private static final MarshallingInfo<String> ENCRYPTIONKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKeyArn").build();
    private static final MarshallingInfo<Map> LOGTYPES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logTypes").build();
    private static final CloudWatchLoggingConfigurationMarshaller instance = new CloudWatchLoggingConfigurationMarshaller();

    public static CloudWatchLoggingConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLoggingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudWatchLoggingConfiguration.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(cloudWatchLoggingConfiguration.getLogGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(cloudWatchLoggingConfiguration.getLogStreamNamePrefix(), LOGSTREAMNAMEPREFIX_BINDING);
            protocolMarshaller.marshall(cloudWatchLoggingConfiguration.getEncryptionKeyArn(), ENCRYPTIONKEYARN_BINDING);
            protocolMarshaller.marshall(cloudWatchLoggingConfiguration.getLogTypes(), LOGTYPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

