/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.PortRange;

@SdkInternalApi
public class PortRangeMarshaller {
    private static final MarshallingInfo<Integer> MINRANGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinRange").build();
    private static final MarshallingInfo<Integer> MAXRANGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRange").build();
    private static final PortRangeMarshaller instance = new PortRangeMarshaller();

    public static PortRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(PortRange portRange, ProtocolMarshaller protocolMarshaller) {
        if (portRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(portRange.getMinRange(), MINRANGE_BINDING);
            protocolMarshaller.marshall(portRange.getMaxRange(), MAXRANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

