/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.DocumentAllowList;
import org.opensearch.security.privileges.PitPrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.PrivilegesInterceptor;
import org.opensearch.security.privileges.ProtectedIndexAccessEvaluator;
import org.opensearch.security.privileges.SnapshotRestoreEvaluator;
import org.opensearch.security.privileges.SystemIndexAccessEvaluator;
import org.opensearch.security.privileges.TenantPrivileges;
import org.opensearch.security.privileges.TermsAggregationEvaluator;
import org.opensearch.security.privileges.actionlevel.RoleBasedActionPrivileges;
import org.opensearch.security.privileges.actionlevel.SubjectBasedActionPrivileges;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.DashboardSignInOption;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.SecurityUtils;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public class PrivilegesEvaluator {
    private static final String USER_TENANT = "__user__";
    private static final String GLOBAL_TENANT = "global_tenant";
    private static final String READ_ACCESS = "READ";
    private static final String WRITE_ACCESS = "WRITE";
    private static final String NO_ACCESS = "NONE";
    static final WildcardMatcher DNFOF_MATCHER = WildcardMatcher.from(ImmutableList.of((Object)"indices:data/read/*", (Object)"indices:admin/mappings/fields/get*", (Object)"indices:admin/shards/search_shards", (Object)"indices:admin/resolve/index", (Object)"indices:monitor/settings/get", (Object)"indices:monitor/stats", (Object)"indices:admin/aliases/get"));
    private static final WildcardMatcher ACTION_MATCHER = WildcardMatcher.from("indices:data/read/*search*");
    private static final IndicesOptions ALLOW_EMPTY = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false);
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Supplier<ClusterState> clusterStateSupplier;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final ClusterInfoHolder clusterInfoHolder;
    private final ConfigurationRepository configurationRepository;
    private ConfigModel configModel;
    private final IndexResolverReplacer irr;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final SystemIndexAccessEvaluator systemIndexAccessEvaluator;
    private final ProtectedIndexAccessEvaluator protectedIndexAccessEvaluator;
    private final TermsAggregationEvaluator termsAggregationEvaluator;
    private final PitPrivilegesEvaluator pitPrivilegesEvaluator;
    private DynamicConfigModel dcm;
    private final Settings settings;
    private final AtomicReference<RoleBasedActionPrivileges> actionPrivileges = new AtomicReference();
    private final AtomicReference<TenantPrivileges> tenantPrivileges = new AtomicReference();
    private final Map<String, SubjectBasedActionPrivileges> pluginIdToActionPrivileges = new HashMap<String, SubjectBasedActionPrivileges>();
    private final FlattenedActionGroups staticActionGroups;

    public PrivilegesEvaluator(ClusterService clusterService, Supplier<ClusterState> clusterStateSupplier, ThreadPool threadPool, ThreadContext threadContext, ConfigurationRepository configurationRepository, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, PrivilegesInterceptor privilegesInterceptor, ClusterInfoHolder clusterInfoHolder, IndexResolverReplacer irr) {
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.threadContext = threadContext;
        this.privilegesInterceptor = privilegesInterceptor;
        this.clusterStateSupplier = clusterStateSupplier;
        this.settings = settings;
        this.checkSnapshotRestoreWritePrivileges = settings.getAsBoolean("plugins.security.check_snapshot_restore_write_privileges", Boolean.valueOf(true));
        this.clusterInfoHolder = clusterInfoHolder;
        this.irr = irr;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(settings, auditLog);
        this.systemIndexAccessEvaluator = new SystemIndexAccessEvaluator(settings, auditLog, irr);
        this.protectedIndexAccessEvaluator = new ProtectedIndexAccessEvaluator(settings, auditLog);
        this.termsAggregationEvaluator = new TermsAggregationEvaluator();
        this.pitPrivilegesEvaluator = new PitPrivilegesEvaluator();
        this.configurationRepository = configurationRepository;
        this.staticActionGroups = new FlattenedActionGroups(DynamicConfigFactory.addStatics(SecurityDynamicConfiguration.empty(CType.ACTIONGROUPS)));
        if (configurationRepository != null) {
            configurationRepository.subscribeOnChange(configMap -> {
                SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsConfiguration = configurationRepository.getConfiguration(CType.ACTIONGROUPS);
                SecurityDynamicConfiguration<RoleV7> rolesConfiguration = configurationRepository.getConfiguration(CType.ROLES);
                SecurityDynamicConfiguration<TenantV7> tenantConfiguration = configurationRepository.getConfiguration(CType.TENANTS);
                this.updateConfiguration(actionGroupsConfiguration, rolesConfiguration, tenantConfiguration);
            });
        }
        if (clusterService != null) {
            clusterService.addListener(event -> {
                RoleBasedActionPrivileges actionPrivileges = this.actionPrivileges.get();
                if (actionPrivileges != null) {
                    actionPrivileges.clusterStateMetadataDependentPrivileges().updateClusterStateMetadataAsync(clusterService, threadPool);
                }
            });
        }
    }

    void updateConfiguration(SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsConfiguration, SecurityDynamicConfiguration<RoleV7> rolesConfiguration, SecurityDynamicConfiguration<TenantV7> tenantConfiguration) {
        FlattenedActionGroups flattenedActionGroups = new FlattenedActionGroups(actionGroupsConfiguration.withStaticConfig());
        rolesConfiguration = rolesConfiguration.withStaticConfig();
        tenantConfiguration = tenantConfiguration.withStaticConfig();
        try {
            RoleBasedActionPrivileges actionPrivileges = new RoleBasedActionPrivileges(rolesConfiguration, flattenedActionGroups, this.settings);
            Metadata metadata = this.clusterStateSupplier.get().metadata();
            actionPrivileges.updateStatefulIndexPrivileges(metadata.getIndicesLookup(), metadata.version());
            RoleBasedActionPrivileges oldInstance = this.actionPrivileges.getAndSet(actionPrivileges);
            if (oldInstance != null) {
                oldInstance.clusterStateMetadataDependentPrivileges().shutdown();
            }
        }
        catch (Exception e) {
            this.log.error("Error while updating ActionPrivileges", (Throwable)e);
        }
        try {
            this.tenantPrivileges.set(new TenantPrivileges(rolesConfiguration, tenantConfiguration, flattenedActionGroups));
        }
        catch (Exception e) {
            this.log.error("Error while updating TenantPrivileges", (Throwable)e);
        }
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.dcm = dcm;
    }

    public boolean hasRestAdminPermissions(User user, TransportAddress remoteAddress, String permission) {
        PrivilegesEvaluationContext context = this.createContext(user, permission);
        return context.getActionPrivileges().hasExplicitClusterPrivilege(context, permission).isAllowed();
    }

    public boolean isInitialized() {
        return this.configModel != null && this.dcm != null && this.actionPrivileges.get() != null;
    }

    private boolean isUserAttributeSerializationEnabled() {
        return this.settings.getAsBoolean("plugins.security.user_attribute_serialization.enabled", Boolean.valueOf(false));
    }

    private void setUserInfoInThreadContext(PrivilegesEvaluationContext context) {
        if (this.threadContext.getTransient("_opendistro_security_user_info") == null) {
            StringJoiner joiner = new StringJoiner("|");
            joiner.add(SecurityUtils.escapePipe(context.getUser().getName()));
            joiner.add(SecurityUtils.escapePipe(String.join((CharSequence)",", context.getUser().getRoles())));
            joiner.add(SecurityUtils.escapePipe(String.join((CharSequence)",", context.getMappedRoles())));
            String requestedTenant = context.getUser().getRequestedTenant();
            joiner.add(requestedTenant);
            String tenantAccessToCheck = this.getTenancyAccess(context);
            joiner.add(tenantAccessToCheck);
            this.log.debug((Object)joiner);
            if (this.isUserAttributeSerializationEnabled()) {
                joiner.add(Base64Helper.serializeObject(context.getUser().getCustomAttributesMap()));
            }
            this.threadContext.putTransient("_opendistro_security_user_info", (Object)joiner.toString());
        }
    }

    public PrivilegesEvaluationContext createContext(User user, String action) {
        return this.createContext(user, action, null, null, null);
    }

    private String getTenancyAccess(PrivilegesEvaluationContext context) {
        String tenant;
        String requestedTenant = context.getUser().getRequestedTenant();
        String string = tenant = Strings.isNullOrEmpty((String)requestedTenant) ? GLOBAL_TENANT : requestedTenant;
        if (this.tenantPrivileges.get().hasTenantPrivilege(context, tenant, TenantPrivileges.ActionType.WRITE)) {
            return WRITE_ACCESS;
        }
        if (this.tenantPrivileges.get().hasTenantPrivilege(context, tenant, TenantPrivileges.ActionType.READ)) {
            return READ_ACCESS;
        }
        return NO_ACCESS;
    }

    public PrivilegesEvaluationContext createContext(User user, String action0, ActionRequest request, Task task, Set<String> injectedRoles) {
        ActionPrivileges actionPrivileges;
        ImmutableSet mappedRoles;
        if (!this.isInitialized()) {
            StringBuilder error = new StringBuilder("OpenSearch Security is not initialized.");
            if (!this.clusterInfoHolder.hasClusterManager().booleanValue()) {
                error.append(String.format(" %s", "Cluster manager not present"));
            }
            throw new OpenSearchSecurityException(error.toString(), new Object[0]);
        }
        TransportAddress caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
        if (user.isPluginUser()) {
            mappedRoles = ImmutableSet.of();
            actionPrivileges = this.pluginIdToActionPrivileges.get(user.getName());
            if (actionPrivileges == null) {
                actionPrivileges = ActionPrivileges.EMPTY;
            }
        } else {
            mappedRoles = ImmutableSet.copyOf(injectedRoles == null ? this.mapRoles(user, caller) : injectedRoles);
            actionPrivileges = this.actionPrivileges.get();
        }
        return new PrivilegesEvaluationContext(user, (ImmutableSet<String>)mappedRoles, action0, request, task, this.irr, this.resolver, this.clusterStateSupplier, actionPrivileges);
    }

    public PrivilegesEvaluatorResponse evaluate(PrivilegesEvaluationContext context) {
        ActionPrivileges actionPrivileges;
        if (!this.isInitialized()) {
            StringBuilder error = new StringBuilder("OpenSearch Security is not initialized.");
            if (!this.clusterInfoHolder.hasClusterManager().booleanValue()) {
                error.append(String.format(" %s", "Cluster manager not present"));
            }
            throw new OpenSearchSecurityException(error.toString(), new Object[0]);
        }
        String action0 = context.getAction();
        ImmutableSet mappedRoles = context.getMappedRoles();
        User user = context.getUser();
        ActionRequest request = context.getRequest();
        Task task = context.getTask();
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        if ("indices:admin/auto_create".equals(action0)) {
            action0 = "indices:admin/create";
        }
        if ("indices:admin/mapping/auto_put".equals(action0)) {
            action0 = "indices:admin/mapping/put";
        }
        PrivilegesEvaluatorResponse presponse = new PrivilegesEvaluatorResponse();
        String injectedRolesValidationString = (String)this.threadContext.getTransient("opendistro_security_injected_roles_validation");
        if (injectedRolesValidationString != null) {
            HashSet<String> injectedRolesValidationSet = new HashSet<String>(Arrays.asList(injectedRolesValidationString.split(",")));
            if (!mappedRoles.containsAll(injectedRolesValidationSet)) {
                presponse.allowed = false;
                presponse.missingSecurityRoles.addAll(injectedRolesValidationSet);
                this.log.info("Roles {} are not mapped to the user {}", injectedRolesValidationSet, (Object)user);
                return presponse;
            }
            mappedRoles = ImmutableSet.copyOf(injectedRolesValidationSet);
            context.setMappedRoles((ImmutableSet<String>)mappedRoles);
        }
        this.setUserInfoInThreadContext(context);
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (isDebugEnabled) {
            this.log.debug("Evaluate permissions for {}", (Object)user);
            this.log.debug("Action: {} ({})", (Object)action0, (Object)request.getClass().getSimpleName());
            this.log.debug("Mapped roles: {}", (Object)mappedRoles.toString());
        }
        if ((actionPrivileges = context.getActionPrivileges()) == null) {
            throw new OpenSearchSecurityException("OpenSearch Security is not initialized: roles configuration is missing", new Object[0]);
        }
        if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
            presponse = actionPrivileges.hasClusterPrivilege(context, action0);
            if (!presponse.allowed) {
                this.log.info("No cluster-level perm match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)action0, (Object)mappedRoles, presponse.getMissingPrivileges());
            }
            return presponse;
        }
        IndexResolverReplacer.Resolved requestedResolved = context.getResolvedRequest();
        if (isDebugEnabled) {
            this.log.debug("RequestedResolved : {}", (Object)requestedResolved);
        }
        if (this.snapshotRestoreEvaluator.evaluate(request, task, action0, this.clusterInfoHolder, presponse).isComplete()) {
            return presponse;
        }
        if (this.systemIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse, context, actionPrivileges, user).isComplete()) {
            return presponse;
        }
        if (this.protectedIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse, (Set<String>)mappedRoles).isComplete()) {
            return presponse;
        }
        if (this.pitPrivilegesEvaluator.evaluate(request, context, actionPrivileges, action0, presponse, this.irr).isComplete()) {
            return presponse;
        }
        boolean dnfofEnabled = this.dcm.isDnfofEnabled();
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("dnfof enabled? {}", (Object)dnfofEnabled);
        }
        boolean serviceAccountUser = user.isServiceAccount();
        if (PrivilegesEvaluator.isClusterPerm(action0)) {
            if (serviceAccountUser) {
                this.log.info("{} is a service account which doesn't have access to cluster level permission: {}", (Object)user, (Object)action0);
                return PrivilegesEvaluatorResponse.insufficient(action0);
            }
            presponse = actionPrivileges.hasClusterPrivilege(context, action0);
            if (!presponse.allowed) {
                this.log.info("No cluster-level perm match for {} {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)requestedResolved, (Object)action0, (Object)mappedRoles, presponse.getMissingPrivileges());
                return presponse;
            }
            if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                if (isDebugEnabled) {
                    this.log.debug("Normally allowed but we need to apply some extra checks for a restore request.");
                }
            } else {
                if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
                    PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, this.dcm, requestedResolved, context, this.tenantPrivileges.get());
                    if (isDebugEnabled) {
                        this.log.debug("Result from privileges interceptor for cluster perm: {}", (Object)replaceResult);
                    }
                    if (!replaceResult.continueEvaluation) {
                        if (replaceResult.accessDenied) {
                            this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                        } else {
                            presponse.allowed = true;
                            presponse.createIndexRequestBuilder = replaceResult.createIndexRequestBuilder;
                        }
                        return presponse;
                    }
                }
                if (isDebugEnabled) {
                    this.log.debug("Allowed because we have cluster permissions for {}", (Object)action0);
                }
                presponse.allowed = true;
                return presponse;
            }
        }
        if (this.checkDocAllowListHeader(user, action0, request)) {
            presponse.allowed = true;
            return presponse;
        }
        if (this.termsAggregationEvaluator.evaluate(requestedResolved, request, context, actionPrivileges, presponse).isComplete()) {
            return presponse;
        }
        ImmutableSet<String> allIndexPermsRequired = this.evaluateAdditionalIndexPermissions(request, action0);
        if (isDebugEnabled) {
            this.log.debug("Requested {} from {}", allIndexPermsRequired, this.threadContext.getTransient("_opendistro_security_remote_address"));
        }
        if (isDebugEnabled) {
            this.log.debug("Requested resolved index types: {}", (Object)requestedResolved);
            this.log.debug("Security roles: {}", (Object)mappedRoles);
        }
        if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
            PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, this.dcm, requestedResolved, context, this.tenantPrivileges.get());
            if (isDebugEnabled) {
                this.log.debug("Result from privileges interceptor: {}", (Object)replaceResult);
            }
            if (!replaceResult.continueEvaluation) {
                if (replaceResult.accessDenied) {
                    this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                    return PrivilegesEvaluatorResponse.insufficient(action0);
                }
                presponse.allowed = true;
                presponse.createIndexRequestBuilder = replaceResult.createIndexRequestBuilder;
                return presponse;
            }
        }
        boolean dnfofPossible = dnfofEnabled && DNFOF_MATCHER.test(action0);
        presponse = actionPrivileges.hasIndexPrivilege(context, (Set<String>)allIndexPermsRequired, requestedResolved);
        if (presponse.isPartiallyOk()) {
            if (dnfofPossible && this.irr.replace((TransportRequest)request, true, presponse.getAvailableIndices())) {
                return PrivilegesEvaluatorResponse.ok();
            }
        } else if (!presponse.isAllowed() && dnfofPossible && this.dcm.isDnfofForEmptyResultsEnabled() && request instanceof IndicesRequest.Replaceable) {
            ((IndicesRequest.Replaceable)request).indices(new String[0]);
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).indicesOptions(ALLOW_EMPTY);
            } else if (request instanceof ClusterSearchShardsRequest) {
                ((ClusterSearchShardsRequest)request).indicesOptions(ALLOW_EMPTY);
            } else if (request instanceof GetFieldMappingsRequest) {
                ((GetFieldMappingsRequest)request).indicesOptions(ALLOW_EMPTY);
            }
            return PrivilegesEvaluatorResponse.ok();
        }
        if (presponse.isAllowed()) {
            if (this.checkFilteredAliases(requestedResolved, action0, isDebugEnabled)) {
                presponse.allowed = false;
                return presponse;
            }
            if (isDebugEnabled) {
                this.log.debug("Allowed because we have all indices permissions for {}", (Object)action0);
            }
        } else {
            this.log.info("No {}-level perm match for {} {}: {} [Action [{}]] [RolesChecked {}]", (Object)"index", (Object)user, (Object)requestedResolved, (Object)presponse.getReason(), (Object)action0, (Object)mappedRoles);
            this.log.info("Index to privilege matrix:\n{}", (Object)presponse.getPrivilegeMatrix());
            if (presponse.hasEvaluationExceptions()) {
                this.log.info("Evaluation errors:\n{}", (Object)presponse.getEvaluationExceptionInfo());
            }
        }
        return presponse;
    }

    public Set<String> mapRoles(User user, TransportAddress caller) {
        return this.configModel.mapSecurityRoles(user, caller);
    }

    public TenantPrivileges tenantPrivileges() {
        return this.tenantPrivileges.get();
    }

    public boolean multitenancyEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDashboardsMultitenancyEnabled();
    }

    public boolean privateTenantEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDashboardsPrivateTenantEnabled();
    }

    public String dashboardsDefaultTenant() {
        return this.dcm.getDashboardsDefaultTenant();
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDnfofEnabled();
    }

    public String dashboardsIndex() {
        return this.dcm.getDashboardsIndexname();
    }

    public String dashboardsServerUsername() {
        return this.dcm.getDashboardsServerUsername();
    }

    public String dashboardsOpenSearchRole() {
        return this.dcm.getDashboardsOpenSearchRole();
    }

    public List<DashboardSignInOption> getSignInOptions() {
        return this.dcm.getSignInOptions();
    }

    private ImmutableSet<String> evaluateAdditionalIndexPermissions(ActionRequest request, String originalAction) {
        ImmutableSet result;
        CreateIndexRequest cir;
        BulkShardRequest bsr;
        ImmutableSet.Builder additionalPermissionsRequired = ImmutableSet.builder();
        if (!PrivilegesEvaluator.isClusterPerm(originalAction)) {
            additionalPermissionsRequired.add((Object)originalAction);
        }
        if (request instanceof ClusterSearchShardsRequest) {
            additionalPermissionsRequired.add((Object)"indices:data/read/search");
        }
        if (request instanceof BulkShardRequest) {
            bsr = (BulkShardRequest)request;
            block9: for (BulkItemRequest bir : bsr.items()) {
                switch (bir.request().opType()) {
                    case CREATE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/index");
                        continue block9;
                    }
                    case INDEX: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/index");
                        continue block9;
                    }
                    case DELETE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/delete");
                        continue block9;
                    }
                    case UPDATE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/update");
                    }
                }
            }
        }
        if (request instanceof IndicesAliasesRequest) {
            bsr = (IndicesAliasesRequest)request;
            for (IndicesAliasesRequest.AliasActions bir : bsr.getAliasActions()) {
                switch (bir.actionType()) {
                    case REMOVE_INDEX: {
                        additionalPermissionsRequired.add((Object)"indices:admin/delete");
                        break;
                    }
                }
            }
        }
        if (request instanceof CreateIndexRequest && (cir = (CreateIndexRequest)request).aliases() != null && !cir.aliases().isEmpty()) {
            additionalPermissionsRequired.add((Object)"indices:admin/aliases");
        }
        if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
            additionalPermissionsRequired.addAll(ConfigConstants.SECURITY_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES);
        }
        if ((result = additionalPermissionsRequired.build()).size() > 1) {
            OpenSearchSecurityPlugin.traceAction("Additional permissions required: {}", result);
        }
        if (this.log.isDebugEnabled() && result.size() > 1) {
            this.log.debug("Additional permissions required: {}", (Object)result);
        }
        return result;
    }

    public static boolean isClusterPerm(String action0) {
        return action0.startsWith("cluster:") || action0.startsWith("indices:admin/template/") || action0.startsWith("indices:admin/index_template/") || action0.startsWith("indices:data/read/scroll") || action0.equals("indices:data/write/bulk") || action0.equals("indices:data/read/mget") || action0.startsWith("indices:data/read/msearch") || action0.equals("indices:data/read/mtv") || action0.equals("indices:data/write/reindex") || action0.equals("indices:data/read/search/template/render");
    }

    private boolean checkFilteredAliases(IndexResolverReplacer.Resolved requestedResolved, String action, boolean isDebugEnabled) {
        Iterable<IndexMetadata> indexMetaDataCollection;
        String faMode = this.dcm.getFilteredAliasMode();
        if (!"disallow".equals(faMode)) {
            return false;
        }
        if (!ACTION_MATCHER.test(action)) {
            return false;
        }
        if (requestedResolved.isLocalAll()) {
            indexMetaDataCollection = new Iterable<IndexMetadata>(){

                @Override
                public Iterator<IndexMetadata> iterator() {
                    return PrivilegesEvaluator.this.clusterStateSupplier.get().getMetadata().getIndices().values().iterator();
                }
            };
        } else {
            HashSet<IndexMetadata> indexMetaDataSet = new HashSet<IndexMetadata>(requestedResolved.getAllIndices().size());
            for (String requestAliasOrIndex : requestedResolved.getAllIndices()) {
                IndexMetadata indexMetaData = (IndexMetadata)this.clusterStateSupplier.get().getMetadata().getIndices().get(requestAliasOrIndex);
                if (indexMetaData == null) {
                    if (!isDebugEnabled) continue;
                    this.log.debug("{} does not exist in cluster metadata", (Object)requestAliasOrIndex);
                    continue;
                }
                indexMetaDataSet.add(indexMetaData);
            }
            indexMetaDataCollection = indexMetaDataSet;
        }
        for (IndexMetadata indexMetaData : indexMetaDataCollection) {
            ArrayList<AliasMetadata> filteredAliases = new ArrayList<AliasMetadata>();
            Map aliases = indexMetaData.getAliases();
            if (aliases != null && aliases.size() > 0) {
                if (isDebugEnabled) {
                    this.log.debug("Aliases for {}: {}", (Object)indexMetaData.getIndex().getName(), (Object)aliases);
                }
                for (String alias : aliases.keySet()) {
                    AliasMetadata aliasMetadata = (AliasMetadata)aliases.get(alias);
                    if (aliasMetadata != null && aliasMetadata.filteringRequired()) {
                        filteredAliases.add(aliasMetadata);
                        if (!isDebugEnabled) continue;
                        this.log.debug("{} is a filtered alias {}", (Object)alias, (Object)aliasMetadata.getFilter());
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    this.log.debug("{} is not an alias or does not have a filter", (Object)alias);
                }
            }
            if (filteredAliases.size() <= 1 || !ACTION_MATCHER.test(action)) continue;
            this.log.error("More than one ({}) filtered alias found for same index ({}). This is currently not supported. Aliases: {}", (Object)filteredAliases.size(), (Object)indexMetaData.getIndex().getName(), this.toString(filteredAliases));
            return true;
        }
        return false;
    }

    private boolean checkDocAllowListHeader(User user, String action, ActionRequest request) {
        String docAllowListHeader = this.threadContext.getHeader("_opendistro_security_doc_allowlist");
        if (docAllowListHeader == null) {
            return false;
        }
        if (!(request instanceof GetRequest)) {
            return false;
        }
        try {
            DocumentAllowList documentAllowList = DocumentAllowList.parse(docAllowListHeader);
            GetRequest getRequest = (GetRequest)request;
            if (documentAllowList.isAllowed(getRequest.index(), getRequest.id())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Request " + String.valueOf(request) + " is allowed by " + String.valueOf(documentAllowList));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("Error while handling document allow list: " + docAllowListHeader, (Throwable)e);
            return false;
        }
    }

    private List<String> toString(List<AliasMetadata> aliases) {
        if (aliases == null || aliases.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(aliases.size());
        for (AliasMetadata amd : aliases) {
            if (amd == null) continue;
            ret.add(amd.alias());
        }
        return Collections.unmodifiableList(ret);
    }

    public void updatePluginToActionPrivileges(String pluginIdentifier, RoleV7 pluginPermissions) {
        this.pluginIdToActionPrivileges.put(pluginIdentifier, new SubjectBasedActionPrivileges(pluginPermissions, this.staticActionGroups));
    }
}

