/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.send;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.notifications.model.SeverityType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lorg/opensearch/notifications/send/SendTestNotificationActionHelper;", "", "<init>", "()V", "generateMessage", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "configId", "", "generateEventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "getMessageTitle", "getMessageTextDescription", "getMessageHtmlDescription", "opensearch-notifications"})
public final class SendTestNotificationActionHelper {
    @NotNull
    public static final SendTestNotificationActionHelper INSTANCE = new SendTestNotificationActionHelper();

    private SendTestNotificationActionHelper() {
    }

    @NotNull
    public final ChannelMessage generateMessage(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return new ChannelMessage(this.getMessageTextDescription(configId), this.getMessageHtmlDescription(configId), null);
    }

    @NotNull
    public final EventSource generateEventSource(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return new EventSource(this.getMessageTitle(configId), configId, SeverityType.INFO, null, 8, null);
    }

    private final String getMessageTitle(String configId) {
        return "Test Message Title-" + configId;
    }

    private final String getMessageTextDescription(String configId) {
        return "Test message content body for config id " + configId;
    }

    private final String getMessageHtmlDescription(String configId) {
        return StringsKt.trimIndent((String)("\n            <html>\n            <header><title>Test Message</title></header>\n            <body>\n            <p>Test Message for config id " + configId + "</p>\n            </body>\n            </html>\n        "));
    }
}

