/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.neuralsearch.sparse.mapper.MethodComponentContext;

public class SparseMethodContext
implements ToXContentFragment,
Writeable {
    private final String name;
    private final MethodComponentContext methodComponentContext;

    public SparseMethodContext(StreamInput in) throws IOException {
        this.name = in.readString();
        this.methodComponentContext = new MethodComponentContext(in, this.name);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.methodComponentContext.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = this.methodComponentContext.toXContent(builder, params);
        return builder;
    }

    public static SparseMethodContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse mapping into SparseMethodContext. Object not of type \"Map\"");
        }
        Map methodMap = (Map)in;
        String name = "";
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String key = (String)methodEntry.getKey();
            Object value = methodEntry.getValue();
            if ("name".equals(key)) {
                name = (String)value;
                continue;
            }
            if ("parameters".equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for main method component");
                }
                parameters = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    Object v = e.getValue();
                    if (v instanceof Map) {
                        throw new IllegalArgumentException("Value should not be map");
                    }
                    return v;
                }));
                continue;
            }
            throw new MapperParsingException("Invalid parameter: " + key);
        }
        if (name.isEmpty()) {
            throw new MapperParsingException("name needs to be set");
        }
        MethodComponentContext methodComponentContext = new MethodComponentContext(name, parameters);
        return new SparseMethodContext(name, methodComponentContext);
    }

    @Generated
    SparseMethodContext(String name, MethodComponentContext methodComponentContext) {
        this.name = name;
        this.methodComponentContext = methodComponentContext;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public MethodComponentContext getMethodComponentContext() {
        return this.methodComponentContext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparseMethodContext)) {
            return false;
        }
        SparseMethodContext other = (SparseMethodContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        MethodComponentContext this$methodComponentContext = this.getMethodComponentContext();
        MethodComponentContext other$methodComponentContext = other.getMethodComponentContext();
        return !(this$methodComponentContext == null ? other$methodComponentContext != null : !((Object)this$methodComponentContext).equals(other$methodComponentContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SparseMethodContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        MethodComponentContext $methodComponentContext = this.getMethodComponentContext();
        result = result * 59 + ($methodComponentContext == null ? 43 : ((Object)$methodComponentContext).hashCode());
        return result;
    }
}

