/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.action.stats.MLStatsNodeResponse;

public class MLStatsNodesResponse
extends BaseNodesResponse<MLStatsNodeResponse>
implements ToXContentObject {
    private static final String NODES_KEY = "nodes";

    public MLStatsNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(MLStatsNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public MLStatsNodesResponse(ClusterName clusterName, List<MLStatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<MLStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<MLStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(MLStatsNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NODES_KEY);
        for (MLStatsNodeResponse mlStats : this.getNodes()) {
            DiscoveryNode node = mlStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            mlStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

