/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.text.ParsePosition;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.stream.Field;

public class DateTimeFieldLenientImpl
extends AbstractField
implements DateTimeField {
    private static final int INITIAL_YEAR = 1970;
    public static final DateTimeFormatter RFC_5322 = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, DateTimeFieldLenientImpl.dayOfWeek()).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, DateTimeFieldLenientImpl.monthOfYear()).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendLiteral(' ').appendOffset("+HHMM", "GMT").optionalEnd().optionalStart().appendLiteral(' ').appendOffsetId().optionalEnd().toFormatter().withZone(ZoneId.of("GMT")).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS).withLocale(Locale.US);
    private boolean parsed = false;
    private Date date;
    public static final FieldParser<DateTimeField> PARSER = new FieldParser<DateTimeField>(){

        @Override
        public DateTimeField parse(Field rawField, DecodeMonitor monitor) {
            return new DateTimeFieldLenientImpl(rawField, monitor);
        }
    };

    private static Map<Long, String> monthOfYear() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "Jan");
        result.put(2L, "Feb");
        result.put(3L, "Mar");
        result.put(4L, "Apr");
        result.put(5L, "May");
        result.put(6L, "Jun");
        result.put(7L, "Jul");
        result.put(8L, "Aug");
        result.put(9L, "Sep");
        result.put(10L, "Oct");
        result.put(11L, "Nov");
        result.put(12L, "Dec");
        return result;
    }

    private static Map<Long, String> dayOfWeek() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "Mon");
        result.put(2L, "Tue");
        result.put(3L, "Wed");
        result.put(4L, "Thu");
        result.put(5L, "Fri");
        result.put(6L, "Sat");
        result.put(7L, "Sun");
        return result;
    }

    private DateTimeFieldLenientImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public Date getDate() {
        if (!this.parsed) {
            this.parse();
        }
        return this.date;
    }

    private void parse() {
        this.parsed = true;
        this.date = null;
        String body = this.getBody();
        if (body != null) {
            body = body.trim();
        }
        try {
            this.date = Date.from(Instant.from(RFC_5322.parse((CharSequence)body, new ParsePosition(0))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

