/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateSearchOnly;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Validate;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "execute", "indexName", "", "hasRemoteStorePrerequisites", "", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "Companion", "opensearch-index-management"})
public class ValidateSearchOnly
extends Validate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    public static final String name = "validate_search_only";
    @NotNull
    private static final String INDEX_BLOCKS_SEARCH_ONLY_SETTING = "index.blocks.search_only";
    @NotNull
    private static final String CLUSTER_REMOTE_STORE_ENABLED_SETTING = "cluster.remote_store.enabled";

    public ValidateSearchOnly(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        super(settings, clusterService, jvmService);
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public Validate execute(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        IndexMetadata indexMetadata = this.getClusterService().state().getMetadata().index(indexName);
        if (indexMetadata == null) {
            String message = Companion.getNoIndexMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return this;
        }
        if (!this.hasRemoteStorePrerequisites(indexMetadata, indexName)) {
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return this;
        }
        this.setValidationMessage(Companion.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean hasRemoteStorePrerequisites(IndexMetadata indexMetadata, String indexName) {
        Integer searchReplicas;
        Settings clusterSettings = this.getClusterService().state().getMetadata().settings();
        Boolean isRemoteStoreEnabled = clusterSettings.getAsBoolean(CLUSTER_REMOTE_STORE_ENABLED_SETTING, Boolean.valueOf(false));
        if (!isRemoteStoreEnabled.booleanValue()) {
            String message = Companion.getRemoteStoreDisabledMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        String replicationType = indexMetadata.getSettings().get("index.replication.type", "DOCUMENT");
        if (!Intrinsics.areEqual((Object)replicationType, (Object)"SEGMENT")) {
            String message = Companion.getSegmentReplicationDisabledMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        Integer n = searchReplicas = indexMetadata.getSettings().getAsInt("index.number_of_search_only_replicas", Integer.valueOf(0));
        if (n != null && n == 0) {
            String message = Companion.getNoSearchReplicasMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateSearchOnly$Companion;", "", "<init>", "()V", "name", "", "INDEX_BLOCKS_SEARCH_ONLY_SETTING", "CLUSTER_REMOTE_STORE_ENABLED_SETTING", "getNoIndexMessage", "index", "getRemoteStoreDisabledMessage", "getSegmentReplicationDisabledMessage", "getNoSearchReplicasMessage", "getValidationPassedMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNoIndexMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "No such index [index=" + index2 + "] for search_only action.";
        }

        @NotNull
        public final String getRemoteStoreDisabledMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Cannot scale to zero without remote store enabled [index=" + index2 + "]";
        }

        @NotNull
        public final String getSegmentReplicationDisabledMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Cannot scale to zero without segment replication [index=" + index2 + "]";
        }

        @NotNull
        public final String getNoSearchReplicasMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Cannot scale to zero without search replicas [index=" + index2 + "]";
        }

        @NotNull
        public final String getValidationPassedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "search_only action validation passed for [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

