/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySnapshotTierResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifySnapshotTierResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(ModifySnapshotTierResponse.getter(ModifySnapshotTierResponse::snapshotId)).setter(ModifySnapshotTierResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<Instant> TIERING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TieringStartTime").getter(ModifySnapshotTierResponse.getter(ModifySnapshotTierResponse::tieringStartTime)).setter(ModifySnapshotTierResponse.setter(Builder::tieringStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringStartTime").unmarshallLocationName("tieringStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, TIERING_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifySnapshotTierResponse.memberNameToFieldInitializer();
    private final String snapshotId;
    private final Instant tieringStartTime;

    private ModifySnapshotTierResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.tieringStartTime = builder.tieringStartTime;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Instant tieringStartTime() {
        return this.tieringStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotTierResponse)) {
            return false;
        }
        ModifySnapshotTierResponse other = (ModifySnapshotTierResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.tieringStartTime(), other.tieringStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySnapshotTierResponse").add("SnapshotId", (Object)this.snapshotId()).add("TieringStartTime", (Object)this.tieringStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "TieringStartTime": {
                return Optional.ofNullable(clazz.cast(this.tieringStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("TieringStartTime", TIERING_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotTierResponse, T> g) {
        return obj -> g.apply((ModifySnapshotTierResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Instant tieringStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotTierResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.tieringStartTime(model.tieringStartTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getTieringStartTime() {
            return this.tieringStartTime;
        }

        public final void setTieringStartTime(Instant tieringStartTime) {
            this.tieringStartTime = tieringStartTime;
        }

        @Override
        public final Builder tieringStartTime(Instant tieringStartTime) {
            this.tieringStartTime = tieringStartTime;
            return this;
        }

        @Override
        public ModifySnapshotTierResponse build() {
            return new ModifySnapshotTierResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySnapshotTierResponse> {
        public Builder snapshotId(String var1);

        public Builder tieringStartTime(Instant var1);
    }
}

