/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSecurityGroupResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteSecurityGroupResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(DeleteSecurityGroupResponse.getter(DeleteSecurityGroupResponse::returnValue)).setter(DeleteSecurityGroupResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DeleteSecurityGroupResponse.getter(DeleteSecurityGroupResponse::groupId)).setter(DeleteSecurityGroupResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSecurityGroupResponse.memberNameToFieldInitializer();
    private final Boolean returnValue;
    private final String groupId;

    private DeleteSecurityGroupResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.groupId = builder.groupId;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final String groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecurityGroupResponse)) {
            return false;
        }
        DeleteSecurityGroupResponse other = (DeleteSecurityGroupResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && Objects.equals(this.groupId(), other.groupId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSecurityGroupResponse").add("Return", (Object)this.returnValue()).add("GroupId", (Object)this.groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Return", RETURN_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSecurityGroupResponse, T> g) {
        return obj -> g.apply((DeleteSecurityGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecurityGroupResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.groupId(model.groupId);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public DeleteSecurityGroupResponse build() {
            return new DeleteSecurityGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSecurityGroupResponse> {
        public Builder returnValue(Boolean var1);

        public Builder groupId(String var1);
    }
}

