/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsResponse;

public class DescribeCapacityBlockExtensionOfferingsPublisher
implements SdkPublisher<DescribeCapacityBlockExtensionOfferingsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityBlockExtensionOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityBlockExtensionOfferingsPublisher(Ec2AsyncClient client, DescribeCapacityBlockExtensionOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityBlockExtensionOfferingsPublisher(Ec2AsyncClient client, DescribeCapacityBlockExtensionOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityBlockExtensionOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityBlockExtensionOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings() {
        Function<DescribeCapacityBlockExtensionOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockExtensionOfferings() != null) {
                return response.capacityBlockExtensionOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityBlockExtensionOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityBlockExtensionOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityBlockExtensionOfferingsResponse> {
        private DescribeCapacityBlockExtensionOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockExtensionOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityBlockExtensionOfferingsResponse> nextPage(DescribeCapacityBlockExtensionOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockExtensionOfferingsPublisher.this.client.describeCapacityBlockExtensionOfferings(DescribeCapacityBlockExtensionOfferingsPublisher.this.firstRequest);
            }
            return DescribeCapacityBlockExtensionOfferingsPublisher.this.client.describeCapacityBlockExtensionOfferings((DescribeCapacityBlockExtensionOfferingsRequest)((Object)DescribeCapacityBlockExtensionOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

