/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstance> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ScheduledInstance.getter(ScheduledInstance::availabilityZone)).setter(ScheduledInstance.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ScheduledInstance.getter(ScheduledInstance::createDate)).setter(ScheduledInstance.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyPrice").getter(ScheduledInstance.getter(ScheduledInstance::hourlyPrice)).setter(ScheduledInstance.setter(Builder::hourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice").unmarshallLocationName("hourlyPrice").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ScheduledInstance.getter(ScheduledInstance::instanceCount)).setter(ScheduledInstance.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ScheduledInstance.getter(ScheduledInstance::instanceType)).setter(ScheduledInstance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> NETWORK_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPlatform").getter(ScheduledInstance.getter(ScheduledInstance::networkPlatform)).setter(ScheduledInstance.setter(Builder::networkPlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPlatform").unmarshallLocationName("networkPlatform").build()}).build();
    private static final SdkField<Instant> NEXT_SLOT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextSlotStartTime").getter(ScheduledInstance.getter(ScheduledInstance::nextSlotStartTime)).setter(ScheduledInstance.setter(Builder::nextSlotStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSlotStartTime").unmarshallLocationName("nextSlotStartTime").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ScheduledInstance.getter(ScheduledInstance::platform)).setter(ScheduledInstance.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<Instant> PREVIOUS_SLOT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PreviousSlotEndTime").getter(ScheduledInstance.getter(ScheduledInstance::previousSlotEndTime)).setter(ScheduledInstance.setter(Builder::previousSlotEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSlotEndTime").unmarshallLocationName("previousSlotEndTime").build()}).build();
    private static final SdkField<ScheduledInstanceRecurrence> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(ScheduledInstance.getter(ScheduledInstance::recurrence)).setter(ScheduledInstance.setter(Builder::recurrence)).constructor(ScheduledInstanceRecurrence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").unmarshallLocationName("recurrence").build()}).build();
    private static final SdkField<String> SCHEDULED_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledInstanceId").getter(ScheduledInstance.getter(ScheduledInstance::scheduledInstanceId)).setter(ScheduledInstance.setter(Builder::scheduledInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceId").unmarshallLocationName("scheduledInstanceId").build()}).build();
    private static final SdkField<Integer> SLOT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SlotDurationInHours").getter(ScheduledInstance.getter(ScheduledInstance::slotDurationInHours)).setter(ScheduledInstance.setter(Builder::slotDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotDurationInHours").unmarshallLocationName("slotDurationInHours").build()}).build();
    private static final SdkField<Instant> TERM_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TermEndDate").getter(ScheduledInstance.getter(ScheduledInstance::termEndDate)).setter(ScheduledInstance.setter(Builder::termEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermEndDate").unmarshallLocationName("termEndDate").build()}).build();
    private static final SdkField<Instant> TERM_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TermStartDate").getter(ScheduledInstance.getter(ScheduledInstance::termStartDate)).setter(ScheduledInstance.setter(Builder::termStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermStartDate").unmarshallLocationName("termStartDate").build()}).build();
    private static final SdkField<Integer> TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalScheduledInstanceHours").getter(ScheduledInstance.getter(ScheduledInstance::totalScheduledInstanceHours)).setter(ScheduledInstance.setter(Builder::totalScheduledInstanceHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalScheduledInstanceHours").unmarshallLocationName("totalScheduledInstanceHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, CREATE_DATE_FIELD, HOURLY_PRICE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, NETWORK_PLATFORM_FIELD, NEXT_SLOT_START_TIME_FIELD, PLATFORM_FIELD, PREVIOUS_SLOT_END_TIME_FIELD, RECURRENCE_FIELD, SCHEDULED_INSTANCE_ID_FIELD, SLOT_DURATION_IN_HOURS_FIELD, TERM_END_DATE_FIELD, TERM_START_DATE_FIELD, TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final Instant createDate;
    private final String hourlyPrice;
    private final Integer instanceCount;
    private final String instanceType;
    private final String networkPlatform;
    private final Instant nextSlotStartTime;
    private final String platform;
    private final Instant previousSlotEndTime;
    private final ScheduledInstanceRecurrence recurrence;
    private final String scheduledInstanceId;
    private final Integer slotDurationInHours;
    private final Instant termEndDate;
    private final Instant termStartDate;
    private final Integer totalScheduledInstanceHours;

    private ScheduledInstance(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.createDate = builder.createDate;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.networkPlatform = builder.networkPlatform;
        this.nextSlotStartTime = builder.nextSlotStartTime;
        this.platform = builder.platform;
        this.previousSlotEndTime = builder.previousSlotEndTime;
        this.recurrence = builder.recurrence;
        this.scheduledInstanceId = builder.scheduledInstanceId;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.termEndDate = builder.termEndDate;
        this.termStartDate = builder.termStartDate;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String hourlyPrice() {
        return this.hourlyPrice;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String networkPlatform() {
        return this.networkPlatform;
    }

    public final Instant nextSlotStartTime() {
        return this.nextSlotStartTime;
    }

    public final String platform() {
        return this.platform;
    }

    public final Instant previousSlotEndTime() {
        return this.previousSlotEndTime;
    }

    public final ScheduledInstanceRecurrence recurrence() {
        return this.recurrence;
    }

    public final String scheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    public final Integer slotDurationInHours() {
        return this.slotDurationInHours;
    }

    public final Instant termEndDate() {
        return this.termEndDate;
    }

    public final Instant termStartDate() {
        return this.termStartDate;
    }

    public final Integer totalScheduledInstanceHours() {
        return this.totalScheduledInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSlotEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.termEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.termStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalScheduledInstanceHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstance)) {
            return false;
        }
        ScheduledInstance other = (ScheduledInstance)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.networkPlatform(), other.networkPlatform()) && Objects.equals(this.nextSlotStartTime(), other.nextSlotStartTime()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.previousSlotEndTime(), other.previousSlotEndTime()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.scheduledInstanceId(), other.scheduledInstanceId()) && Objects.equals(this.slotDurationInHours(), other.slotDurationInHours()) && Objects.equals(this.termEndDate(), other.termEndDate()) && Objects.equals(this.termStartDate(), other.termStartDate()) && Objects.equals(this.totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledInstance").add("AvailabilityZone", (Object)this.availabilityZone()).add("CreateDate", (Object)this.createDate()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceType()).add("NetworkPlatform", (Object)this.networkPlatform()).add("NextSlotStartTime", (Object)this.nextSlotStartTime()).add("Platform", (Object)this.platform()).add("PreviousSlotEndTime", (Object)this.previousSlotEndTime()).add("Recurrence", (Object)this.recurrence()).add("ScheduledInstanceId", (Object)this.scheduledInstanceId()).add("SlotDurationInHours", (Object)this.slotDurationInHours()).add("TermEndDate", (Object)this.termEndDate()).add("TermStartDate", (Object)this.termStartDate()).add("TotalScheduledInstanceHours", (Object)this.totalScheduledInstanceHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "HourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "NetworkPlatform": {
                return Optional.ofNullable(clazz.cast(this.networkPlatform()));
            }
            case "NextSlotStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextSlotStartTime()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PreviousSlotEndTime": {
                return Optional.ofNullable(clazz.cast(this.previousSlotEndTime()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "ScheduledInstanceId": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceId()));
            }
            case "SlotDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.slotDurationInHours()));
            }
            case "TermEndDate": {
                return Optional.ofNullable(clazz.cast(this.termEndDate()));
            }
            case "TermStartDate": {
                return Optional.ofNullable(clazz.cast(this.termStartDate()));
            }
            case "TotalScheduledInstanceHours": {
                return Optional.ofNullable(clazz.cast(this.totalScheduledInstanceHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("HourlyPrice", HOURLY_PRICE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("NetworkPlatform", NETWORK_PLATFORM_FIELD);
        map.put("NextSlotStartTime", NEXT_SLOT_START_TIME_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("PreviousSlotEndTime", PREVIOUS_SLOT_END_TIME_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("ScheduledInstanceId", SCHEDULED_INSTANCE_ID_FIELD);
        map.put("SlotDurationInHours", SLOT_DURATION_IN_HOURS_FIELD);
        map.put("TermEndDate", TERM_END_DATE_FIELD);
        map.put("TermStartDate", TERM_START_DATE_FIELD);
        map.put("TotalScheduledInstanceHours", TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstance, T> g) {
        return obj -> g.apply((ScheduledInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Instant createDate;
        private String hourlyPrice;
        private Integer instanceCount;
        private String instanceType;
        private String networkPlatform;
        private Instant nextSlotStartTime;
        private String platform;
        private Instant previousSlotEndTime;
        private ScheduledInstanceRecurrence recurrence;
        private String scheduledInstanceId;
        private Integer slotDurationInHours;
        private Instant termEndDate;
        private Instant termStartDate;
        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstance model) {
            this.availabilityZone(model.availabilityZone);
            this.createDate(model.createDate);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.networkPlatform(model.networkPlatform);
            this.nextSlotStartTime(model.nextSlotStartTime);
            this.platform(model.platform);
            this.previousSlotEndTime(model.previousSlotEndTime);
            this.recurrence(model.recurrence);
            this.scheduledInstanceId(model.scheduledInstanceId);
            this.slotDurationInHours(model.slotDurationInHours);
            this.termEndDate(model.termEndDate);
            this.termStartDate(model.termStartDate);
            this.totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getNetworkPlatform() {
            return this.networkPlatform;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final Instant getNextSlotStartTime() {
            return this.nextSlotStartTime;
        }

        public final void setNextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
        }

        @Override
        public final Builder nextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final Instant getPreviousSlotEndTime() {
            return this.previousSlotEndTime;
        }

        public final void setPreviousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
        }

        @Override
        public final Builder previousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
            return this;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final String getScheduledInstanceId() {
            return this.scheduledInstanceId;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final Integer getSlotDurationInHours() {
            return this.slotDurationInHours;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final Instant getTermEndDate() {
            return this.termEndDate;
        }

        public final void setTermEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
        }

        @Override
        public final Builder termEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
            return this;
        }

        public final Instant getTermStartDate() {
            return this.termStartDate;
        }

        public final void setTermStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
        }

        @Override
        public final Builder termStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
            return this;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return this.totalScheduledInstanceHours;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public ScheduledInstance build() {
            return new ScheduledInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstance> {
        public Builder availabilityZone(String var1);

        public Builder createDate(Instant var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder networkPlatform(String var1);

        public Builder nextSlotStartTime(Instant var1);

        public Builder platform(String var1);

        public Builder previousSlotEndTime(Instant var1);

        public Builder recurrence(ScheduledInstanceRecurrence var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrence)((ScheduledInstanceRecurrence.Builder)ScheduledInstanceRecurrence.builder().applyMutation(recurrence)).build());
        }

        public Builder scheduledInstanceId(String var1);

        public Builder slotDurationInHours(Integer var1);

        public Builder termEndDate(Instant var1);

        public Builder termStartDate(Instant var1);

        public Builder totalScheduledInstanceHours(Integer var1);
    }
}

