/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtension;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityBlockExtensionHistoryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityBlockExtensionHistoryResponse> {
    private static final SdkField<List<CapacityBlockExtension>> CAPACITY_BLOCK_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityBlockExtensions").getter(DescribeCapacityBlockExtensionHistoryResponse.getter(DescribeCapacityBlockExtensionHistoryResponse::capacityBlockExtensions)).setter(DescribeCapacityBlockExtensionHistoryResponse.setter(Builder::capacityBlockExtensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionSet").unmarshallLocationName("capacityBlockExtensionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityBlockExtension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityBlockExtensionHistoryResponse.getter(DescribeCapacityBlockExtensionHistoryResponse::nextToken)).setter(DescribeCapacityBlockExtensionHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_EXTENSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityBlockExtensionHistoryResponse.memberNameToFieldInitializer();
    private final List<CapacityBlockExtension> capacityBlockExtensions;
    private final String nextToken;

    private DescribeCapacityBlockExtensionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlockExtensions = builder.capacityBlockExtensions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityBlockExtensions() {
        return this.capacityBlockExtensions != null && !(this.capacityBlockExtensions instanceof SdkAutoConstructList);
    }

    public final List<CapacityBlockExtension> capacityBlockExtensions() {
        return this.capacityBlockExtensions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityBlockExtensions() ? this.capacityBlockExtensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockExtensionHistoryResponse)) {
            return false;
        }
        DescribeCapacityBlockExtensionHistoryResponse other = (DescribeCapacityBlockExtensionHistoryResponse)((Object)obj);
        return this.hasCapacityBlockExtensions() == other.hasCapacityBlockExtensions() && Objects.equals(this.capacityBlockExtensions(), other.capacityBlockExtensions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityBlockExtensionHistoryResponse").add("CapacityBlockExtensions", this.hasCapacityBlockExtensions() ? this.capacityBlockExtensions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockExtensions": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockExtensionSet", CAPACITY_BLOCK_EXTENSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockExtensionHistoryResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlockExtensionHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityBlockExtension> capacityBlockExtensions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockExtensionHistoryResponse model) {
            super(model);
            this.capacityBlockExtensions(model.capacityBlockExtensions);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityBlockExtension.Builder> getCapacityBlockExtensions() {
            List<CapacityBlockExtension.Builder> result = CapacityBlockExtensionSetCopier.copyToBuilder(this.capacityBlockExtensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlockExtensions(Collection<CapacityBlockExtension.BuilderImpl> capacityBlockExtensions) {
            this.capacityBlockExtensions = CapacityBlockExtensionSetCopier.copyFromBuilder(capacityBlockExtensions);
        }

        @Override
        public final Builder capacityBlockExtensions(Collection<CapacityBlockExtension> capacityBlockExtensions) {
            this.capacityBlockExtensions = CapacityBlockExtensionSetCopier.copy(capacityBlockExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensions(CapacityBlockExtension ... capacityBlockExtensions) {
            this.capacityBlockExtensions(Arrays.asList(capacityBlockExtensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensions(Consumer<CapacityBlockExtension.Builder> ... capacityBlockExtensions) {
            this.capacityBlockExtensions(Stream.of(capacityBlockExtensions).map(c -> (CapacityBlockExtension)((CapacityBlockExtension.Builder)CapacityBlockExtension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlockExtensionHistoryResponse build() {
            return new DescribeCapacityBlockExtensionHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityBlockExtensionHistoryResponse> {
        public Builder capacityBlockExtensions(Collection<CapacityBlockExtension> var1);

        public Builder capacityBlockExtensions(CapacityBlockExtension ... var1);

        public Builder capacityBlockExtensions(Consumer<CapacityBlockExtension.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

