/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.aggregation;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.support.AggregationPath;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.opensearch.search.profile.aggregation.AggregationProfiler;
import org.opensearch.search.profile.aggregation.AggregationTimingType;
import org.opensearch.search.profile.aggregation.ProfilingLeafBucketCollector;
import org.opensearch.search.sort.SortOrder;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        return this.delegate.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        return this.delegate.bucketComparator(key, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            InternalAggregation[] internalAggregationArray = this.delegate.buildAggregations(owningBucketOrds);
            return internalAggregationArray;
        }
        finally {
            timer.stop();
            this.delegate.collectDebugInfo(this.profileBreakdown::addDebugInfo);
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_LEAF_COLLECTOR);
        timer.start();
        try {
            ProfilingLeafBucketCollector profilingLeafBucketCollector = new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
            return profilingLeafBucketCollector;
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
        super.reset();
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.POST_COLLECTION);
        timer.start();
        try {
            this.delegate.postCollection();
        }
        finally {
            timer.stop();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Aggregator unwrapAggregator() {
        return this.delegate;
    }
}

