/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilterDTO;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConfiguration {
    protected static final String FILTER_PANEL_CURRENT_FILTER = "filter.current.filter";
    protected static final String FILTER_PANEL_AVAILABLE_FILTERS = "filter.available.filters.filter_";
    private static final String KEY_UUID_SPLITERATOR = "_";
    private static final Logger LOG = LoggerFactory.getLogger(FilterConfiguration.class);
    private static final CopyOnWriteArraySet<Runnable> availableFiltersChangedCallbacks = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<Consumer<FilterDTO>> currentFilterChangedCallbacks = new CopyOnWriteArraySet();
    private final Configuration configuration;

    public FilterConfiguration() {
        this(ApplicationConfiguration.getConfiguration());
    }

    public FilterConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.migrateOldFilterConfigurations();
    }

    public static void addAvailableFiltersObserver(Runnable availableFiltersChangedCallback) {
        availableFiltersChangedCallbacks.add(availableFiltersChangedCallback);
    }

    public static void addCurrentFiltersObserver(Consumer<FilterDTO> currentFilterChangedCallback) {
        currentFilterChangedCallbacks.add(currentFilterChangedCallback);
    }

    private void migrateOldFilterConfigurations() {
        FilterDTO newFilter = new FilterDTO(UUID.randomUUID(), "Alter Filter");
        if (this.migrateAll(() -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_ABOS.getOldKey(), newFilter, Boolean.class, this::setDontShowAbos), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_AUDIO_VERSIONS.getOldKey(), newFilter, Boolean.class, this::setDontShowAudioVersions), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_SIGN_LANGUAGE.getOldKey(), newFilter, Boolean.class, this::setDontShowSignLanguage), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_TRAILERS.getOldKey(), newFilter, Boolean.class, this::setDontShowTrailers), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MAX.getOldKey(), newFilter, Double.class, this::setFilmLengthMax), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MIN.getOldKey(), newFilter, Double.class, this::setFilmLengthMin), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_HD_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowHdOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_LIVESTREAMS_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowLivestreamsOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_NEW_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowNewOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_BOOK_MARKED_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowBookMarkedOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_SUBTITLES_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowSubtitlesOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_SHOW_UNSEEN_ONLY.getOldKey(), newFilter, Boolean.class, this::setShowUnseenOnly), () -> this.migrateOldFilterConfiguration(FilterConfigurationKeys.FILTER_PANEL_ZEITRAUM.getOldKey(), newFilter, String.class, this::setZeitraum))) {
            this.addNewFilter(newFilter);
            LOG.info("Filter migration abgeschlossen.");
        }
    }

    @SafeVarargs
    private boolean migrateAll(Supplier<Boolean> ... migrationSteps) {
        return !Arrays.stream(migrationSteps).map(Supplier::get).filter(Boolean::booleanValue).collect(Collectors.toUnmodifiableList()).isEmpty();
    }

    private <T> boolean migrateOldFilterConfiguration(String oldFilterConfigKey, FilterDTO newFilter, Class<T> classOfValueType, Consumer<T> newFilterSetter) {
        if (this.configuration.containsKey(oldFilterConfigKey)) {
            LOG.info("Alte Filter Konfiguration {} mit dem Wert {} gefunden. Migriere es zu einer neuen Filter Konfiguration mit der Filter ID {}.", oldFilterConfigKey, this.configuration.getString(oldFilterConfigKey), newFilter.id());
            this.setCurrentFilter(newFilter);
            T oldValue = this.configuration.get(classOfValueType, oldFilterConfigKey);
            if (oldValue == null) {
                LOG.info("Filter Konfiguration {} ist null, ignoriere Konfiguration f\u00fcr Migration.", (Object)oldFilterConfigKey);
            } else {
                newFilterSetter.accept(oldValue);
                this.configuration.clearProperty(oldFilterConfigKey);
                return true;
            }
        }
        return false;
    }

    public boolean isShowHdOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_HD_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowHdOnly(boolean showHdOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_HD_ONLY.getKey()), showHdOnly);
        return this;
    }

    private String toFilterConfigNameWithCurrentFilter(String filterConfigNamePattern) {
        return String.format(filterConfigNamePattern, this.getCurrentFilterID());
    }

    public boolean isShowSubtitlesOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_SUBTITLES_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowSubtitlesOnly(boolean showSubtitlesOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_SUBTITLES_ONLY.getKey()), showSubtitlesOnly);
        return this;
    }

    public boolean isShowNewOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_NEW_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowNewOnly(boolean showNewOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_NEW_ONLY.getKey()), showNewOnly);
        return this;
    }

    public boolean isShowBookMarkedOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_BOOK_MARKED_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowBookMarkedOnly(boolean showBookMarkedOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_BOOK_MARKED_ONLY.getKey()), showBookMarkedOnly);
        return this;
    }

    public boolean isShowUnseenOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_UNSEEN_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowUnseenOnly(boolean showUnseenOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_UNSEEN_ONLY.getKey()), showUnseenOnly);
        return this;
    }

    public boolean isShowLivestreamsOnly() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_LIVESTREAMS_ONLY.getKey()), false);
    }

    public FilterConfiguration setShowLivestreamsOnly(boolean showLivestreamsOnly) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_SHOW_LIVESTREAMS_ONLY.getKey()), showLivestreamsOnly);
        return this;
    }

    public boolean isDontShowAbos() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_ABOS.getKey()), false);
    }

    public FilterConfiguration setDontShowAbos(boolean dontShowAbos) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_ABOS.getKey()), dontShowAbos);
        return this;
    }

    public boolean isDontShowTrailers() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_TRAILERS.getKey()), false);
    }

    public FilterConfiguration setDontShowTrailers(boolean dontShowTrailers) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_TRAILERS.getKey()), dontShowTrailers);
        return this;
    }

    public boolean isDontShowSignLanguage() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_SIGN_LANGUAGE.getKey()), false);
    }

    public FilterConfiguration setDontShowSignLanguage(boolean dontShowSignLanguage) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_SIGN_LANGUAGE.getKey()), dontShowSignLanguage);
        return this;
    }

    public boolean isDontShowAudioVersions() {
        return this.configuration.getBoolean(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_AUDIO_VERSIONS.getKey()), false);
    }

    public FilterConfiguration setDontShowAudioVersions(boolean dontShowAudioVersions) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_DONT_SHOW_AUDIO_VERSIONS.getKey()), dontShowAudioVersions);
        return this;
    }

    public double getFilmLengthMin() {
        return this.configuration.getDouble(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MIN.getKey()), 0.0);
    }

    public FilterConfiguration setFilmLengthMin(double filmLengthMin) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MIN.getKey()), filmLengthMin);
        return this;
    }

    public double getFilmLengthMax() {
        return this.configuration.getDouble(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MAX.getKey()), 110.0);
    }

    public FilterConfiguration setFilmLengthMax(double filmLengthMax) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_FILM_LENGTH_MAX.getKey()), filmLengthMax);
        return this;
    }

    public String getZeitraum() {
        return this.configuration.getString(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_ZEITRAUM.getKey()), "\u221e");
    }

    public FilterConfiguration setZeitraum(String zeitraum) {
        this.configuration.setProperty(this.toFilterConfigNameWithCurrentFilter(FilterConfigurationKeys.FILTER_PANEL_ZEITRAUM.getKey()), zeitraum);
        return this;
    }

    public FilterConfiguration clearCurrentFilter() {
        Arrays.stream(FilterConfigurationKeys.values()).map(FilterConfigurationKeys::getKey).map(this::toFilterConfigNameWithCurrentFilter).forEach(this.configuration::clearProperty);
        return this;
    }

    public UUID getCurrentFilterID() {
        return this.getCurrentFilter().id();
    }

    public FilterDTO getCurrentFilter() {
        if (!this.configuration.containsKey(FILTER_PANEL_CURRENT_FILTER) || this.configuration.get(UUID.class, FILTER_PANEL_CURRENT_FILTER) == null) {
            this.setCurrentFilter(this.getAvailableFilters().stream().findFirst().orElseGet(() -> {
                FilterDTO newFilter = new FilterDTO(UUID.randomUUID(), "Filter 1");
                this.addNewFilter(newFilter);
                return newFilter;
            }));
        }
        UUID currentFilterId = this.configuration.get(UUID.class, FILTER_PANEL_CURRENT_FILTER);
        return new FilterDTO(currentFilterId, this.getFilterName(currentFilterId));
    }

    public FilterConfiguration setCurrentFilter(FilterDTO currentFilter) {
        return this.setCurrentFilter(currentFilter.id());
    }

    public FilterConfiguration setCurrentFilter(UUID currentFilterID) {
        this.configuration.setProperty(FILTER_PANEL_CURRENT_FILTER, currentFilterID);
        currentFilterChangedCallbacks.forEach((Consumer<Consumer<FilterDTO>>)((Consumer<Consumer>)consumer -> consumer.accept(this.getCurrentFilter())));
        return this;
    }

    public List<UUID> getAvailableFilterIds() {
        return this.getAvailableFilters().stream().map(FilterDTO::id).collect(Collectors.toUnmodifiableList());
    }

    public List<String> getAvailableFilterNames() {
        return this.getAvailableFilters().stream().map(FilterDTO::name).collect(Collectors.toUnmodifiableList());
    }

    public List<FilterDTO> getAvailableFilters() {
        ArrayList availableFilterKeys = new ArrayList();
        this.configuration.getKeys().forEachRemaining(key -> {
            if (key.startsWith(FILTER_PANEL_AVAILABLE_FILTERS)) {
                availableFilterKeys.add(key);
            }
        });
        return availableFilterKeys.stream().map(key -> new FilterDTO(UUID.fromString(key.split(KEY_UUID_SPLITERATOR)[1]), this.configuration.getProperty((String)key).toString())).collect(Collectors.toUnmodifiableList());
    }

    public String getFilterName(UUID id) {
        return this.getAvailableFilters().stream().filter(filter -> filter.id().equals(id)).map(FilterDTO::name).findFirst().orElse("");
    }

    public FilterConfiguration addNewFilter(FilterDTO filterDTO) {
        this.configuration.addProperty(FILTER_PANEL_AVAILABLE_FILTERS + String.valueOf(filterDTO.id()), filterDTO.name());
        availableFiltersChangedCallbacks.forEach(Runnable::run);
        return this;
    }

    public FilterConfiguration addNewFilter(UUID filterId, String filterName) {
        return this.addNewFilter(new FilterDTO(filterId, filterName));
    }

    public FilterConfiguration deleteFilter(FilterDTO filterToDelete) {
        return this.deleteFilter(filterToDelete.id());
    }

    public FilterConfiguration deleteFilter(UUID idToDelete) {
        boolean filterToDeleteIsCurrentFilter = idToDelete.equals(this.getCurrentFilterID());
        if (filterToDeleteIsCurrentFilter) {
            this.configuration.clearProperty(FILTER_PANEL_CURRENT_FILTER);
        }
        this.configuration.getKeys().forEachRemaining(key -> this.clearPropertyWithKeyIfContainsId(idToDelete, (String)key));
        availableFiltersChangedCallbacks.forEach(Runnable::run);
        if (filterToDeleteIsCurrentFilter) {
            currentFilterChangedCallbacks.forEach((Consumer<Consumer<FilterDTO>>)((Consumer<Consumer>)consumer -> consumer.accept(this.getCurrentFilter())));
        }
        return this;
    }

    private void clearPropertyWithKeyIfContainsId(UUID idToDelete, String key) {
        if (key.contains(idToDelete.toString())) {
            this.configuration.clearProperty(key);
        }
    }

    public FilterConfiguration renameCurrentFilter(String newName) {
        this.configuration.setProperty(FILTER_PANEL_AVAILABLE_FILTERS + String.valueOf(this.getCurrentFilterID()), newName);
        availableFiltersChangedCallbacks.forEach(Runnable::run);
        currentFilterChangedCallbacks.forEach((Consumer<Consumer<FilterDTO>>)((Consumer<Consumer>)consumer -> consumer.accept(this.getCurrentFilter())));
        return this;
    }

    public Optional<FilterDTO> findFilterForName(String name) {
        return this.getAvailableFilters().stream().filter(filter -> filter.name().equals(name)).findFirst();
    }

    protected static enum FilterConfigurationKeys {
        FILTER_PANEL_SHOW_HD_ONLY("filter.filter_%s.show.hd_only"),
        FILTER_PANEL_SHOW_SUBTITLES_ONLY("filter.filter_%s.show.subtitles_only"),
        FILTER_PANEL_SHOW_BOOK_MARKED_ONLY("filter.filter_%s.show.book_marked_only"),
        FILTER_PANEL_SHOW_NEW_ONLY("filter.filter_%s.show.new_only"),
        FILTER_PANEL_SHOW_UNSEEN_ONLY("filter.filter_%s.show.unseen_only"),
        FILTER_PANEL_SHOW_LIVESTREAMS_ONLY("filter.filter_%s.show.livestreams_only"),
        FILTER_PANEL_DONT_SHOW_ABOS("filter.filter_%s.dont_show.abos"),
        FILTER_PANEL_DONT_SHOW_TRAILERS("filter.filter_%s.dont_show.trailers"),
        FILTER_PANEL_DONT_SHOW_SIGN_LANGUAGE("filter.filter_%s.dont_show.sign_language"),
        FILTER_PANEL_DONT_SHOW_AUDIO_VERSIONS("filter.filter_%s.dont_show.audio_versions"),
        FILTER_PANEL_FILM_LENGTH_MIN("filter.filter_%s.film_length.min"),
        FILTER_PANEL_FILM_LENGTH_MAX("filter.filter_%s.film_length.max"),
        FILTER_PANEL_ZEITRAUM("filter.filter_%s.zeitraum");

        private final String key;

        private FilterConfigurationKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getOldKey() {
            return this.key.replace(".filter_%s", "");
        }
    }
}

