import type { HandlerDataFetch } from '@sentry/types';
/**
 * Add an instrumentation handler for when a fetch request happens.
 * The handler function is called once when the request starts and once when it ends,
 * which can be identified by checking if it has an `endTimestamp`.
 *
 * Use at your own risk, this might break without changelog notice, only used internally.
 * @hidden
 */
export declare function addFetchInstrumentationHandler(handler: (data: HandlerDataFetch) => void): void;
/**
 * Parses the fetch arguments to find the used Http method and the url of the request.
 * Exported for tests only.
 */
export declare function parseFetchArgs(fetchArgs: unknown[]): {
    method: string;
    url: string;
};
//# sourceMappingURL=fetch.d.ts.map